/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.apache.ivyde.eclipse.cp.AdvancedSetup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AdvancedSetupEditor
extends Composite {
    private Button resolveBeforeLaunchCheck;
    private Button useExtendedResolveIdCheck;

    public AdvancedSetupEditor(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.resolveBeforeLaunchCheck = new Button((Composite)this, 32);
        this.resolveBeforeLaunchCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resolveBeforeLaunchCheck.setText("Resolve before launch");
        this.resolveBeforeLaunchCheck.setToolTipText("Trigger a resolve before each run of any kind of java launch configuration");
        this.useExtendedResolveIdCheck = new Button((Composite)this, 32);
        this.useExtendedResolveIdCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.useExtendedResolveIdCheck.setText("Use extended resolve id");
        this.useExtendedResolveIdCheck.setToolTipText("Will append status, branch and revision info to the default resolve id");
    }

    public void init(AdvancedSetup setup, boolean forceResolveBeforeLaunch) {
        this.resolveBeforeLaunchCheck.setSelection(setup.isResolveBeforeLaunch());
        this.useExtendedResolveIdCheck.setSelection(setup.isUseExtendedResolveId());
        if (forceResolveBeforeLaunch) {
            this.resolveBeforeLaunchCheck.setEnabled(false);
            this.resolveBeforeLaunchCheck.setSelection(true);
        }
    }

    public AdvancedSetup getAdvancedSetup() {
        AdvancedSetup setup = new AdvancedSetup();
        setup.setResolveBeforeLaunch(this.resolveBeforeLaunchCheck.getSelection());
        setup.setUseExtendedResolveId(this.useExtendedResolveIdCheck.getSelection());
        return setup;
    }

    public void setEnabled(boolean enabled) {
        this.resolveBeforeLaunchCheck.setEnabled(enabled);
        this.useExtendedResolveIdCheck.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

