/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.apache.ivyde.eclipse.cp.MappingSetup;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MappingSetupEditor
extends Composite {
    public static final String TOOLTIP_SOURCE_TYPES = "Comma separated list of artifact types to be used as sources.\nExample: source, src";
    public static final String TOOLTIP_JAVADOC_TYPES = "Comma separated list of artifact types to be used as javadoc.\nExample: javadoc.";
    public static final String TOOLTIP_SOURCE_SUFFIXES = "Comma separated list of suffixes to match sources to jars in the classpath.\nExample: -source, -src";
    public static final String TOOLTIP_JAVADOC_SUFFIXES = "Comma separated list of suffixes to match javadocs to jars in the classpath.\nExample: -javadoc, -doc";
    public static final String TOOLTIP_MAP_IF_ONLY_ONE_SOURCE = "Will map the source artifact to all jar artifact in modules with multiple jar artifacts and only one source artifact";
    public static final String TOOLTIP_MAP_IF_ONLY_ONE_JAVADOC = "Will map the javadoc artifact to all jar artifact in modules with multiple jar artifacts and only one javadoc artifact";
    private Text sourceTypesText;
    private Text sourceSuffixesText;
    private Text javadocTypesText;
    private Text javadocSuffixesText;
    private Button mapIfOnlyOneSourceCheck;
    private Button mapIfOnlyOneJavadocCheck;
    private Label sourceTypesLabel;
    private Label sourceSuffixesLabel;
    private Label javadocTypesLabel;
    private Label javadocSuffixesLabel;

    public MappingSetupEditor(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.sourceTypesLabel = new Label((Composite)this, 0);
        this.sourceTypesLabel.setText("Sources types:");
        this.sourceTypesText = new Text((Composite)this, 2052);
        this.sourceTypesText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.sourceTypesText.setToolTipText(TOOLTIP_SOURCE_TYPES);
        this.sourceSuffixesLabel = new Label((Composite)this, 0);
        this.sourceSuffixesLabel.setText("Sources suffixes:");
        this.sourceSuffixesText = new Text((Composite)this, 2052);
        this.sourceSuffixesText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sourceSuffixesText.setToolTipText(TOOLTIP_SOURCE_SUFFIXES);
        this.javadocTypesLabel = new Label((Composite)this, 0);
        this.javadocTypesLabel.setText("Javadoc types:");
        this.javadocTypesText = new Text((Composite)this, 2052);
        this.javadocTypesText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.javadocTypesText.setToolTipText(TOOLTIP_JAVADOC_TYPES);
        this.javadocSuffixesLabel = new Label((Composite)this, 0);
        this.javadocSuffixesLabel.setText("Javadoc suffixes:");
        this.javadocSuffixesText = new Text((Composite)this, 2052);
        this.javadocSuffixesText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.javadocSuffixesText.setToolTipText(TOOLTIP_JAVADOC_SUFFIXES);
        this.mapIfOnlyOneSourceCheck = new Button((Composite)this, 32);
        this.mapIfOnlyOneSourceCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.mapIfOnlyOneSourceCheck.setText("Auto map jar artifacts with unique source artifact");
        this.mapIfOnlyOneSourceCheck.setToolTipText(TOOLTIP_MAP_IF_ONLY_ONE_SOURCE);
        this.mapIfOnlyOneJavadocCheck = new Button((Composite)this, 32);
        this.mapIfOnlyOneJavadocCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.mapIfOnlyOneJavadocCheck.setText("Auto map jar artifacts with unique javadoc artifact");
        this.mapIfOnlyOneJavadocCheck.setToolTipText(TOOLTIP_MAP_IF_ONLY_ONE_JAVADOC);
    }

    public void init(MappingSetup setup) {
        this.sourceTypesText.setText(IvyClasspathUtil.concat(setup.getSourceTypes()));
        this.sourceSuffixesText.setText(IvyClasspathUtil.concat(setup.getSourceSuffixes()));
        this.javadocTypesText.setText(IvyClasspathUtil.concat(setup.getJavadocTypes()));
        this.javadocSuffixesText.setText(IvyClasspathUtil.concat(setup.getJavadocSuffixes()));
        this.mapIfOnlyOneSourceCheck.setSelection(setup.isMapIfOnlyOneSource());
        this.mapIfOnlyOneJavadocCheck.setSelection(setup.isMapIfOnlyOneJavadoc());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.sourceTypesLabel.setEnabled(enabled);
        this.sourceTypesText.setEnabled(enabled);
        this.sourceSuffixesLabel.setEnabled(enabled);
        this.sourceSuffixesText.setEnabled(enabled);
        this.javadocTypesLabel.setEnabled(enabled);
        this.javadocTypesText.setEnabled(enabled);
        this.javadocSuffixesLabel.setEnabled(enabled);
        this.javadocSuffixesText.setEnabled(enabled);
        this.mapIfOnlyOneSourceCheck.setEnabled(enabled);
        this.mapIfOnlyOneJavadocCheck.setEnabled(enabled);
    }

    public MappingSetup getMappingSetup() {
        MappingSetup setup = new MappingSetup();
        setup.setSourceTypes(IvyClasspathUtil.split(this.sourceTypesText.getText()));
        setup.setJavadocTypes(IvyClasspathUtil.split(this.javadocTypesText.getText()));
        setup.setSourceSuffixes(IvyClasspathUtil.split(this.sourceSuffixesText.getText()));
        setup.setJavadocSuffixes(IvyClasspathUtil.split(this.javadocSuffixesText.getText()));
        setup.setMapIfOnlyOneSource(this.mapIfOnlyOneSourceCheck.getSelection());
        setup.setMapIfOnlyOneJavadoc(this.mapIfOnlyOneJavadocCheck.getSelection());
        return setup;
    }
}

