/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.apache.ivyde.eclipse.cp.RetrieveSetup;
import org.apache.ivyde.internal.eclipse.ui.PathEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RetrieveComposite
extends Composite {
    public static final String TOOLTIP_RETRIEVE_PATTERN = "Exemple: lib/[conf]/[artifact].[ext]\nTo copy artifacts in folder named lib without revision by folder named like configurations";
    public static final String TOOLTIP_RETRIEVE_CONFS = "Comma separated list of configuration to retrieve\nExemple: '*' or 'compile,test'";
    public static final String TOOLTIP_RETRIEVE_TYPES = "Comma separated list of types to retrieve\nExemple: '*' or 'jar,source'";
    private static final String DEFAULT_PATTERN = "/[type]s/[artifact]-[revision](-[classifier]).[ext]";
    private PathEditor retrievePatternText;
    private Button retrieveSyncButton;
    private Text confsText;
    private Text typesText;

    public RetrieveComposite(Composite parent, int style, boolean withConf, IProject project) {
        super(parent, style);
        Label label;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.retrievePatternText = new PathEditor(this, 0, "Retrieve pattern", project, null){
            private Button addPattern;

            protected boolean addButtons(Composite buttons) {
                this.addPattern = new Button(buttons, 0);
                this.addPattern.setLayoutData((Object)new GridData(3, 2, true, false));
                this.addPattern.setText("Add def. pattern");
                this.addPattern.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.getText().setText(String.valueOf(this.this$1.getText().getText()) + "/[type]s/[artifact]-[revision](-[classifier]).[ext]");
                    }
                });
                return true;
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.addPattern.setEnabled(enabled);
            }
        };
        this.retrievePatternText.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.retrievePatternText.setToolTipText(TOOLTIP_RETRIEVE_PATTERN);
        this.retrieveSyncButton = new Button((Composite)this, 32);
        this.retrieveSyncButton.setText("Delete old retrieved artifacts");
        this.retrieveSyncButton.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        if (withConf) {
            label = new Label((Composite)this, 0);
            label.setText("Configurations:");
            this.confsText = new Text((Composite)this, 2052);
            this.confsText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.confsText.setToolTipText(TOOLTIP_RETRIEVE_CONFS);
        }
        label = new Label((Composite)this, 0);
        label.setText("Types:");
        this.typesText = new Text((Composite)this, 2052);
        this.typesText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.typesText.setToolTipText(TOOLTIP_RETRIEVE_TYPES);
    }

    public RetrieveSetup getRetrieveSetup() {
        RetrieveSetup setup = new RetrieveSetup();
        setup.setRetrieveSync(this.retrieveSyncButton.getSelection());
        setup.setRetrievePattern(this.retrievePatternText.getText().getText());
        if (this.confsText != null) {
            setup.setRetrieveConfs(this.confsText.getText());
        }
        setup.setRetrieveTypes(this.typesText.getText());
        return setup;
    }

    public void init(RetrieveSetup setup) {
        this.retrievePatternText.getText().setText(setup.getRetrievePattern());
        this.retrieveSyncButton.setSelection(setup.isRetrieveSync());
        if (this.confsText != null) {
            this.confsText.setText(setup.getRetrieveConfs());
        }
        this.typesText.setText(setup.getRetrieveTypes());
        this.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.retrievePatternText.setEnabled(enabled);
        this.retrieveSyncButton.setEnabled(enabled);
        if (this.confsText != null) {
            this.confsText.setEnabled(enabled);
        }
        this.typesText.setEnabled(enabled);
    }
}

