/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.common.ivyfile.IvyModuleDescriptorModel;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.common.model.IvyModelSettings;
import org.apache.ivyde.eclipse.extension.IvyEditorPage;
import org.apache.ivyde.eclipse.extension.ModuleDescriptorExtension;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.core.IvyFileEditorInput;
import org.apache.ivyde.internal.eclipse.ui.editors.IvyEditorPageDescriptor;
import org.apache.ivyde.internal.eclipse.ui.editors.ModuleDescriptorExtensionDescriptor;
import org.apache.ivyde.internal.eclipse.ui.editors.pages.OverviewFormPage;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.EclipseIvyModelSettings;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.IvyContentAssistProcessor;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.XMLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class IvyModuleDescriptorEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String ID = "org.apache.ivyde.editors.IvyEditor";
    private XMLEditor xmlEditor;
    private Browser browser;
    private List ivyEditorPageDescriptors = new ArrayList();
    private List moduleDescriptorExtensionDescriptors = new ArrayList();

    public IvyModuleDescriptorEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.parseModuleDescriptorExtensionMetadatas();
        this.parseEditorPageExtensionMetadatas();
    }

    private void parseModuleDescriptorExtensionMetadatas() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.apache.ivyde.eclipse.moduleDescriptorExtension").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                ModuleDescriptorExtensionDescriptor descriptor = new ModuleDescriptorExtensionDescriptor(configElements[j]);
                this.moduleDescriptorExtensionDescriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
    }

    private void parseEditorPageExtensionMetadatas() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.apache.ivyde.eclipse.editorPage").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IvyEditorPageDescriptor descriptor = new IvyEditorPageDescriptor(configElements[j]);
                this.ivyEditorPageDescriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
    }

    protected void setInput(IEditorInput input) {
        IvyFileEditorInput ivyFileEditorInput = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            IFile file = fei.getFile();
            ivyFileEditorInput = new IvyFileEditorInput(file);
        } else if (input instanceof IvyFileEditorInput) {
            ivyFileEditorInput = (IvyFileEditorInput)input;
        }
        super.setInput((IEditorInput)ivyFileEditorInput);
        if (ivyFileEditorInput.getFile() != null && this.xmlEditor != null) {
            this.xmlEditor.setFile(ivyFileEditorInput.getFile());
        }
        this.setPartName(ivyFileEditorInput.getFile().getName());
    }

    void createPageXML() {
        try {
            this.xmlEditor = new XMLEditor(new IvyContentAssistProcessor(){

                protected IvyModel newCompletionModel(IFile file) {
                    return IvyModuleDescriptorEditor.this.getIvyCompletionModel(new EclipseIvyModelSettings(file));
                }
            });
            this.xmlEditor.setFile(((IvyFileEditorInput)this.getEditorInput()).getFile());
            int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            this.setPageText(index, this.xmlEditor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private IvyModuleDescriptorModel getIvyCompletionModel(IvyModelSettings ivyModelSettings) {
        IvyModuleDescriptorModel ivyModuleDescriptorModel = new IvyModuleDescriptorModel(ivyModelSettings);
        Iterator iterator = this.moduleDescriptorExtensionDescriptors.iterator();
        while (iterator.hasNext()) {
            ModuleDescriptorExtensionDescriptor descriptor = (ModuleDescriptorExtensionDescriptor)iterator.next();
            ModuleDescriptorExtension moduleDescriptorExtension = descriptor.createModuleDescriptorExtension();
            if (moduleDescriptorExtension == null) continue;
            ivyModuleDescriptorModel = moduleDescriptorExtension.contributeModel(ivyModuleDescriptorModel);
        }
        return ivyModuleDescriptorModel;
    }

    void createPageOverView() {
        try {
            int index = this.addPage((IFormPage)new OverviewFormPage(this));
            this.setPageText(index, "Information");
        }
        catch (PartInitException e) {
            IvyPlugin.logError("The overview page could not be created", e);
        }
    }

    void createPagePreview() {
        try {
            this.browser = new Browser(this.getContainer(), 0);
            this.browser.setUrl(((IvyFileEditorInput)this.getEditorInput()).getPath().toOSString());
            int index = this.addPage((Control)this.browser);
            this.setPageText(index, "Preview");
        }
        catch (SWTError e) {
            MessageDialog.openError((Shell)IvyPlugin.getActiveWorkbenchShell(), (String)"Fail to create the preview", (String)("The page preview could not be created :" + e.getMessage()));
            IvyPlugin.logError("The preview page in the ivy.xml editor could not be created", e);
        }
    }

    protected void addPages() {
        this.createPageXML();
        this.addIvyEditorPageExtensions();
    }

    private void addIvyEditorPageExtensions() {
        Iterator iterator = this.ivyEditorPageDescriptors.iterator();
        while (iterator.hasNext()) {
            IvyEditorPageDescriptor ivyEditorPageDescriptor = (IvyEditorPageDescriptor)iterator.next();
            IvyEditorPage page = ivyEditorPageDescriptor.createPage();
            try {
                page.initialize(this);
                int pageIndex = this.addPage(page);
                this.setPageText(pageIndex, page.getPageName());
            }
            catch (PartInitException e) {
                IvyPlugin.log(4, "Cannot add Ivy editor extension", e);
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.xmlEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.xmlEditor.doSaveAs();
        this.setPageText(0, this.xmlEditor.getTitle());
        this.setInput(this.xmlEditor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return this.xmlEditor.isSaveAsAllowed();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1 && this.browser != null) {
            this.browser.refresh();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            final IResource res = event.getResource();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = IvyModuleDescriptorEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((IFileEditorInput)IvyModuleDescriptorEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)res)) {
                            IEditorPart editorPart = pages[i].findEditor(IvyModuleDescriptorEditor.this.xmlEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

