/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.protocol.outline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernException;
import tern.angular.AngularType;
import tern.angular.modules.AngularElement;
import tern.angular.modules.Controller;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.Module;
import tern.angular.protocol.outline.AngularOutline;
import tern.angular.protocol.outline.AngularOutlineQuery;
import tern.angular.protocol.outline.IAngularOutlineListener;
import tern.server.TernPlugin;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.outline.IJSNode;
import tern.server.protocol.outline.IJSNodeRoot;
import tern.server.protocol.outline.TernOutlineCollector;
import tern.server.protocol.outline.TernOutlineResultProcessor;
import tern.server.protocol.push.IMessageHandler;

public class AngularOutlineProvider
extends TernOutlineCollector
implements IMessageHandler {
    private final List<IAngularOutlineListener> listeners = new ArrayList<IAngularOutlineListener>();
    private AngularOutline outline;

    public AngularOutlineProvider(ITernProject ternProject) {
        super(ternProject);
        ternProject.on("angular:modelChanged", this);
    }

    @Override
    protected IJSNodeRoot doCreateRoot() {
        if (this.outline == null) {
            this.outline = new AngularOutline(this.getTernProject());
        } else {
            this.outline.clear();
        }
        return this.outline;
    }

    public boolean init() throws IOException, TernException {
        if (this.outline == null) {
            this.outline = new AngularOutline(this.getTernProject());
            this.loadOutline();
            this.fireOutlineChanged();
            return false;
        }
        return true;
    }

    @Override
    public IJSNode createNode(String name, String type, String kind, String value, Long start, Long end, String file, IJSNode parent, Object jsonNode, IJSONObjectHelper helper) {
        AngularType angularType = AngularType.get(kind);
        if (angularType != AngularType.unknown) {
            switch (angularType) {
                case module: {
                    return new Module(name, start, end, file, parent);
                }
                case controller: {
                    return new Controller(name, null, start, end, file, parent);
                }
                case directive: {
                    ArrayList<String> tagNames = new ArrayList<String>();
                    String restrict = null;
                    DirectiveValue directiveValue = DirectiveValue.none;
                    return new Directive(name, AngularType.model, null, tagNames, restrict, directiveValue, start, end, file, parent);
                }
            }
            return new AngularElement(name, angularType, start, end, file, parent);
        }
        return super.createNode(name, type, kind, value, start, end, file, parent, jsonNode, helper);
    }

    public AngularOutline getOutline() throws IOException, TernException {
        return this.outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOutlineChanged() {
        List<IAngularOutlineListener> list = this.listeners;
        synchronized (list) {
            for (IAngularOutlineListener listener : this.listeners) {
                listener.changed(this.outline);
            }
        }
    }

    protected void loadOutline() throws IOException, TernException {
        AngularOutlineQuery query = new AngularOutlineQuery();
        this.getTernProject().request(query, null, this);
    }

    public void refresh(ITernFile ternFile) throws IOException, TernException {
        ITernProject ternProject = this.getTernProject();
        if (ternProject.hasPlugin(TernPlugin.push)) {
            return;
        }
        AngularOutlineQuery query = new AngularOutlineQuery();
        query.setFile(ternFile.getFileName());
        ternProject.request(query, ternFile, this);
    }

    @Override
    public void handleMessage(Object jsonObject, IJSONObjectHelper helper) {
        if (this.outline == null) {
            this.outline = new AngularOutline(this.getTernProject());
        }
        TernOutlineResultProcessor.INSTANCE.process((TernDoc)null, helper, jsonObject, this);
        this.fireOutlineChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAngularOutlineListener(IAngularOutlineListener listener) {
        List<IAngularOutlineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAngularOutlineListener(IAngularOutlineListener listener) {
        List<IAngularOutlineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public IJSNodeRoot getRoot() {
        try {
            return this.getOutline();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getRoot();
        }
    }
}

