/*
 * Decompiled with CFR 0.152.
 */
package tern.repository;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import tern.TernException;
import tern.repository.TernModuleToDownload;
import tern.server.ITernModule;
import tern.utils.IOUtils;
import tern.utils.StringUtils;

public class TernRepositoryHelper {
    public static final String DEFAULT_TERN_REPOSITORY_URL = "https://raw.githubusercontent.com/paulvi/tern-plugins/master/plugins.json";

    private TernRepositoryHelper() {
    }

    public static List<ITernModule> loadModules(String repositoryURL) throws IOException, TernException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(repositoryURL);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = httpResponse.getEntity();
        InputStream in = entity.getContent();
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode != 200) {
            String message = IOUtils.toString(in);
            if (StringUtils.isEmpty(message)) {
                throw new TernException(statusLine.toString());
            }
            throw new TernException(message);
        }
        JsonObject repository = JsonObject.readFrom((Reader)new InputStreamReader(in));
        TernModuleToDownload module = null;
        ArrayList<ITernModule> modules = new ArrayList<ITernModule>();
        for (JsonObject.Member member : repository) {
            module = new TernModuleToDownload(member.getName(), (JsonObject)member.getValue());
            modules.add(module);
        }
        return modules;
    }
}

