/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static final String ZIP_EXTENSION = ".zip";
    private static final String JAR_EXTENSION = ".jar";
    private static final String BIN_FOLDER = "/bin";

    private ZipUtils() {
    }

    public static boolean isZipFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(ZIP_EXTENSION);
    }

    public static boolean isJarFile(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(JAR_EXTENSION);
    }

    public static void extract(File file, File destination) throws IOException {
        ZipInputStream in = null;
        OutputStream out = null;
        try {
            in = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String outFilename = entry.getName();
                File extracted = new File(destination, outFilename);
                if (entry.isDirectory()) {
                    extracted.mkdirs();
                    continue;
                }
                File baseDir = extracted.getParentFile();
                if (!baseDir.exists()) {
                    baseDir.mkdirs();
                }
                out = new FileOutputStream(extracted);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                if (!extracted.getParent().contains(BIN_FOLDER)) continue;
                extracted.setExecutable(true);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

