/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeKind;

public final class JavaTypeConstraintServiceData {
    private final SortedSet<JavaTypeKind> kinds;
    private final SortedSet<String> types;
    private final JavaTypeConstraintBehavior behavior;

    public JavaTypeConstraintServiceData(Collection<JavaTypeKind> kinds, Collection<String> types, JavaTypeConstraintBehavior behavior) {
        TreeSet<JavaTypeKind> kindsCopy = new TreeSet<JavaTypeKind>();
        for (JavaTypeKind kind : kinds) {
            if (kind == null) continue;
            kindsCopy.add(kind);
        }
        this.kinds = Collections.unmodifiableSortedSet(kindsCopy);
        TreeSet<String> typesCopy = new TreeSet<String>();
        for (String type : types) {
            if (type == null || (type = type.trim()).length() <= 0) continue;
            typesCopy.add(type);
        }
        this.types = Collections.unmodifiableSortedSet(typesCopy);
        this.behavior = behavior == null ? JavaTypeConstraintBehavior.ALL : behavior;
    }

    public JavaTypeConstraintServiceData(Collection<JavaTypeKind> kinds, Collection<String> types) {
        this(kinds, types, JavaTypeConstraintBehavior.ALL);
    }

    public SortedSet<JavaTypeKind> kinds() {
        return this.kinds;
    }

    public SortedSet<String> types() {
        return this.types;
    }

    public JavaTypeConstraintBehavior behavior() {
        return this.behavior;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaTypeConstraintServiceData) {
            JavaTypeConstraintServiceData data = (JavaTypeConstraintServiceData)obj;
            return this.kinds.equals(data.kinds) && this.types.equals(data.types) && this.behavior == data.behavior;
        }
        return false;
    }

    public int hashCode() {
        return this.kinds.hashCode() ^ this.types.hashCode() ^ this.behavior.hashCode();
    }
}

