/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core;

import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoConnection;
import com.liferay.ide.kaleo.core.WorkflowSupportManager;
import com.liferay.ide.kaleo.core.util.IWorkflowValidation;
import com.liferay.ide.kaleo.core.util.WorkflowValidationProxy;
import com.liferay.ide.server.core.ILiferayServer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.BundleContext;

public class KaleoCore
extends Plugin {
    public static final String DEFAULT_KALEO_VERSION = "7.0.0";
    public static final String PLUGIN_ID = "com.liferay.ide.kaleo.core";
    public static final QualifiedName DEFAULT_SCRIPT_LANGUAGE_KEY = new QualifiedName("com.liferay.ide.kaleo.core", "defaultScriptLanguage");
    public static final QualifiedName DEFAULT_TEMPLATE_LANGUAGE_KEY = new QualifiedName("com.liferay.ide.kaleo.core", "defaultTemplateLanguage");
    public static final QualifiedName GRID_VISIBLE_KEY = new QualifiedName("com.liferay.ide.kaleo.core", "gridVisible");
    private static HashMap<String, IKaleoConnection> kaleoConnections;
    private static KaleoCore plugin;
    private static HashMap<String, IWorkflowValidation> workflowValidators;
    private WorkflowSupportManager workflowSupportManager;

    public static IStatus createErrorStatus(String msg) {
        return KaleoCore.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static KaleoCore getDefault() {
        return plugin;
    }

    public static IKaleoConnection getKaleoConnection(final ILiferayServer liferayServer) {
        IKaleoConnection service;
        if (kaleoConnections == null) {
            kaleoConnections = new HashMap();
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)new IServerLifecycleListener(){

                public void serverAdded(IServer server) {
                }

                public void serverChanged(IServer server) {
                }

                public void serverRemoved(IServer s) {
                    IKaleoConnection service;
                    if (liferayServer.equals(s) && (service = (IKaleoConnection)kaleoConnections.get(liferayServer.getId())) != null) {
                        service = null;
                        kaleoConnections.put(liferayServer.getId(), null);
                    }
                }
            });
        }
        if ((service = kaleoConnections.get(liferayServer.getId())) == null) {
            service = new KaleoConnection();
            KaleoCore.updateKaleoConnectionSettings(liferayServer, service);
            kaleoConnections.put(liferayServer.getId(), service);
        }
        return service;
    }

    public static IKaleoConnection getKaleoConnection(IServer parent) {
        return KaleoCore.getKaleoConnection((ILiferayServer)parent.loadAdapter(ILiferayServer.class, null));
    }

    public static IWorkflowValidation getWorkflowValidation(IRuntime runtime) {
        IWorkflowValidation validator;
        if (workflowValidators == null) {
            workflowValidators = new HashMap();
        }
        if ((validator = workflowValidators.get(runtime.getId())) == null) {
            Class[] interfaces = new Class[]{IWorkflowValidation.class};
            validator = (IWorkflowValidation)Proxy.newProxyInstance(IWorkflowValidation.class.getClassLoader(), interfaces, (InvocationHandler)((Object)new WorkflowValidationProxy(runtime)));
            workflowValidators.put(runtime.getId(), validator);
        }
        return validator;
    }

    public static void logError(Exception e) {
        KaleoCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public static void logError(String msg, Exception e) {
        KaleoCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static void updateKaleoConnectionSettings(ILiferayServer server) {
        KaleoCore.updateKaleoConnectionSettings(server, KaleoCore.getKaleoConnection(server));
    }

    public static void updateKaleoConnectionSettings(ILiferayServer server, IKaleoConnection connection) {
        connection.setHost(server.getHost());
        connection.setHttpPort(server.getHttpPort());
        connection.setPortalHtmlUrl(server.getPortalHomeUrl());
        connection.setPortalContextPath("/");
        connection.setUsername(server.getUsername());
        connection.setPassword(server.getPassword());
    }

    public synchronized WorkflowSupportManager getWorkflowSupportManager() {
        if (this.workflowSupportManager == null) {
            this.workflowSupportManager = new WorkflowSupportManager();
        }
        return this.workflowSupportManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

