/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core;

import com.liferay.ide.core.util.CoreUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;

public class WorkflowSupportManager {
    public static final String SUPPORT_PROJECT_NAME = "Kaleo Designer Support";
    private IServer currentServer;

    public IJavaProject getSupportProject() {
        try {
            this.checkForSupportProject();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(SUPPORT_PROJECT_NAME);
            if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public void setCurrentServer(IServer server) {
        this.currentServer = server;
    }

    private void checkForSupportProject() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(SUPPORT_PROJECT_NAME);
            if (!project.exists() || !project.isOpen()) {
                this.createSupportProject((IProgressMonitor)new NullProgressMonitor());
            }
            this.computeClasspath(JavaCore.create((IProject)project), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IProject createSupportProject(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(SUPPORT_PROJECT_NAME);
        if (project.exists()) {
            if (!project.isOpen()) {
                project.open(monitor);
            }
            return project;
        }
        project.create(CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)1));
        project.open(CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)1));
        CoreUtil.makeFolders((IFolder)project.getFolder("src"));
        CoreUtil.addNaturesToProject((IProject)project, (String[])new String[]{"org.eclipse.jdt.core.javanature"}, (IProgressMonitor)CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)1));
        IJavaProject jProject = JavaCore.create((IProject)project);
        jProject.setOutputLocation(project.getFullPath().append("bin"), CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)1));
        this.computeClasspath(jProject, CoreUtil.newSubMonitor((IProgressMonitor)monitor, (int)1));
        return project;
    }

    private void computeClasspath(IJavaProject project, IProgressMonitor monitor) {
        int numEntries = 2;
        Path runtimeContainerPath = null;
        try {
            String id = this.currentServer.getRuntime().getId();
            runtimeContainerPath = new Path("org.eclipse.jst.server.core.container/com.liferay.ide.eclipse.server.tomcat.runtimeClasspathProvider/" + id);
            ++numEntries;
        }
        catch (Throwable id) {
            // empty catch block
        }
        IClasspathEntry[] classpath = new IClasspathEntry[numEntries];
        classpath[0] = JavaCore.newContainerEntry((IPath)JavaRuntime.newDefaultJREContainerPath());
        classpath[1] = JavaCore.newSourceEntry((IPath)project.getProject().getFolder("src").getFullPath());
        if (runtimeContainerPath != null) {
            classpath[2] = JavaCore.newContainerEntry((IPath)runtimeContainerPath);
        }
        try {
            project.setRawClasspath(classpath, monitor);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

