/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.model.Node;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Version;

public class TransitionPossibleValuesService
extends PossibleValuesService {
    protected void compute(Set<String> values) {
        Element modelElement = (Element)this.context(Element.class);
        WorkflowDefinition workflow = (WorkflowDefinition)modelElement.nearest(WorkflowDefinition.class);
        if (workflow == null) {
            workflow = (WorkflowDefinition)modelElement.adapt(WorkflowDefinition.class);
        }
        if (workflow != null) {
            this.addNodeNames(values, workflow.getTasks());
            this.addNodeNames(values, workflow.getStates());
            this.addNodeNames(values, workflow.getConditions());
            this.addNodeNames(values, workflow.getForks());
            this.addNodeNames(values, workflow.getJoins());
            Version version = (Version)workflow.getSchemaVersion().content();
            if (version.compareTo(new Version("6.2")) >= 0) {
                this.addNodeNames(values, workflow.getJoinXors());
            }
        }
    }

    protected void addNodeNames(Set<String> values, ElementList<?> nodeList) {
        Node[] nodes;
        Node[] nodeArray = nodes = (Node[])nodeList.toArray((Object[])new Node[0]);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            String name = (String)node.getName().content();
            if (!CoreUtil.empty((String)name)) {
                values.add(name);
            }
            ++n2;
        }
    }
}

