/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.util;

import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.scripting.core.GroovyScriptProxy;
import com.liferay.ide.server.core.ILiferayRuntime;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Version;

public class WorkflowValidationProxy
extends GroovyScriptProxy {
    private IRuntime runtime;

    public WorkflowValidationProxy(IRuntime runtime) {
        this.runtime = runtime;
    }

    protected URL[] getProxyClasspath() throws CoreException {
        File[] jars;
        String[] libs;
        ArrayList<URL> scriptUrlList = new ArrayList<URL>();
        IRuntime serverRuntime = this.runtime;
        if (serverRuntime == null) {
            throw new CoreException(KaleoCore.createErrorStatus("Could not get server runtime."));
        }
        ILiferayRuntime liferayRuntime = (ILiferayRuntime)serverRuntime.loadAdapter(ILiferayRuntime.class, null);
        File libFolder = liferayRuntime.getAppServerPortalDir().append("WEB-INF/lib").toFile();
        String[] stringArray = libs = libFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && (name.contains("dom4j") || name.contains("xercesImpl") || name.contains("portal-impl") || name.contains("util-java") || name.contains("commons-lang"));
            }
        });
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            File libJar = new File(libFolder, lib);
            if (libJar.exists()) {
                try {
                    scriptUrlList.add(libJar.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        File[] fileArray = jars = new File[]{this.runtime.getLocation().append("webapps/kaleo-designer-portlet/WEB-INF/lib/kaleo-web-service.jar").toFile(), this.runtime.getLocation().append("lib/ext/portal-service.jar").toFile()};
        int n3 = jars.length;
        n = 0;
        while (n < n3) {
            File jar = fileArray[n];
            if (jar.exists()) {
                try {
                    scriptUrlList.add(jar.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n;
        }
        File parserDir = this.runtime.getLocation().append("webapps/kaleo-web/WEB-INF/classes/").toFile();
        if (parserDir.exists()) {
            try {
                scriptUrlList.add(parserDir.toURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return scriptUrlList.toArray(new URL[0]);
    }

    protected File getGroovyFile() throws Exception {
        ILiferayRuntime liferayRuntime = (ILiferayRuntime)this.runtime.loadAdapter(ILiferayRuntime.class, null);
        if (liferayRuntime != null) {
            Version version = new Version(liferayRuntime.getPortalVersion());
            return new File(FileLocator.toFileURL((URL)KaleoCore.getDefault().getBundle().getEntry(this.getGroovyWorkflowValidationScript(version))).getFile());
        }
        IStatus error = KaleoCore.createErrorStatus("Unable to locate groovy script");
        KaleoCore.getDefault().getLog().log(error);
        throw new CoreException(error);
    }

    private String getGroovyWorkflowValidationScript(Version runtimeVersion) {
        int result = runtimeVersion.compareTo(new Version(6, 1, 30));
        if (result > 0) {
            return "/scripts/portal/WorkflowValidation620.groovy";
        }
        if (result == 0) {
            return "/scripts/portal/WorkflowValidation6130.groovy";
        }
        return "/scripts/portal/WorkflowValidation6120.groovy";
    }
}

