/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.BestMatchHover;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.xml.search.editor.hover.XMLReferencesInfoHoverProcessor;
import org.eclipse.wst.xml.search.editor.hyperlink.XMLReferencesHyperlinkDetector;
import org.eclipse.wst.xml.search.editor.internal.contentassist.XMLReferencesContentAssistProcessor;
import org.eclipse.wst.xml.search.editor.internal.style.LineStyleProviderForXMLReferences;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.style.LineStyleProviderForXML;

public class XMLReferencesStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    private static final IHyperlinkDetector[] IHYPERLINK_DETECTOR_EMPTY = new IHyperlinkDetector[0];
    private LineStyleProvider fLineStyleProviderForXML;

    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT" ? new IContentAssistProcessor[]{this.createContentAssistProcessor()} : super.getContentAssistProcessors(sourceViewer, partitionType);
        return processors;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] superDetectors;
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>();
        allDetectors.add(this.createHyperlinkDetector());
        IHyperlinkDetector[] aihyperlinkdetector = superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int j = superDetectors.length;
        int i = 0;
        while (i < j) {
            IHyperlinkDetector detector = aihyperlinkdetector[i];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++i;
        }
        return allDetectors.toArray(IHYPERLINK_DETECTOR_EMPTY);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ProblemAnnotationHoverProcessor textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && XMLReferencesStructuredTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new BestMatchHover(this.createDocumentationHover(contentType));
                } else if ("documentationHover".equalsIgnoreCase(hoverType)) {
                    textHover = this.createDocumentationHover(contentType);
                }
            }
            ++i;
        }
        return textHover;
    }

    protected ITextHover createDocumentationHover(String partitionType) {
        ITextHover textHover = null;
        if (partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT") {
            return new XMLReferencesInfoHoverProcessor();
        }
        Object extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfiguration("documentationTextHover", partitionType);
        if (extendedTextHover instanceof ITextHover) {
            textHover = (ITextHover)extendedTextHover;
        }
        return textHover;
    }

    protected IContentAssistProcessor createContentAssistProcessor() {
        return new XMLReferencesContentAssistProcessor();
    }

    protected IHyperlinkDetector createHyperlinkDetector() {
        return new XMLReferencesHyperlinkDetector();
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        if (partitionType == "org.eclipse.wst.xml.XML_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_CDATA" || partitionType == "org.eclipse.wst.xml.XML_COMMENT" || partitionType == "org.eclipse.wst.xml.XML_DECL" || partitionType == "org.eclipse.wst.xml.XML_PI") {
            providers = new LineStyleProvider[]{this.getLineStyleProviderForXML(sourceViewer)};
        }
        return providers;
    }

    private LineStyleProvider getLineStyleProviderForXML(ISourceViewer sourceViewer) {
        if (this.fLineStyleProviderForXML == null) {
            this.fLineStyleProviderForXML = this.isColorReferencedNodes() ? new LineStyleProviderForXMLReferences(sourceViewer) : new LineStyleProviderForXML();
        }
        return this.fLineStyleProviderForXML;
    }

    protected boolean isColorReferencedNodes() {
        return true;
    }
}

