/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.hyperlink;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesFileHyperlink
implements IHyperlink {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final IRegion region;
    private final IStorage propertiesFile;
    private final String keyName;
    private final IEditorPart editor;

    public PropertiesFileHyperlink(IRegion region, IStorage propertiesFile, String keyName, IEditorPart editor) {
        this.region = region;
        this.propertiesFile = propertiesFile;
        this.keyName = keyName;
        this.editor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return "Open '";
    }

    public void open() {
        PropertiesFileHyperlink.openKeyInPropertiesFile(this.keyName, this.propertiesFile, this.editor);
    }

    public static void openKeyInPropertiesFile(String keyName, IStorage propertiesFile, IEditorPart activeEditor) {
        IEditorPart editor;
        if (propertiesFile == null) {
            return;
        }
        try {
            editor = EditorUtility.openInEditor((Object)propertiesFile, (boolean)true);
        }
        catch (PartInitException partInitException) {
            PropertiesFileHyperlink.handleOpenPropertiesFileFailed(propertiesFile, activeEditor);
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        IDocument document = null;
        if (editor instanceof ITextEditor) {
            document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editorInput);
        } else {
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) {
                IPath path = file.getFullPath();
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                try {
                    manager.connect(path, LocationKind.IFILE, null);
                    try {
                        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                        if (buffer != null) {
                            document = buffer.getDocument();
                        }
                    }
                    finally {
                        manager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log((Throwable)ex);
                }
            }
        }
        boolean found = false;
        IRegion region = null;
        if (document != null) {
            FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
            PropertyKeyHyperlinkDetector detector = new PropertyKeyHyperlinkDetector();
            detector.setContext((IAdaptable)editor);
            String key = PropertiesFileHyperlink.unwindEscapeChars(keyName);
            int offset = document.getLength() - 1;
            try {
                while (!found && offset >= 0) {
                    region = finder.find(offset, key, false, true, false, false);
                    if (region == null) {
                        offset = -1;
                        continue;
                    }
                    IHyperlink[] hyperlinks = detector.detectHyperlinks(null, region, false);
                    if (hyperlinks != null) {
                        int i = 0;
                        while (i < hyperlinks.length) {
                            IRegion hyperlinkRegion = hyperlinks[i].getHyperlinkRegion();
                            found = key.equals(document.get(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength()));
                            ++i;
                        }
                    } else if (document instanceof IDocumentExtension3) {
                        ITypedRegion partition = null;
                        partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", region.getOffset(), false);
                        found = "__dftl_partition_content_type".equals(partition.getType()) && key.equals(document.get(partition.getOffset(), partition.getLength()).trim());
                    }
                    offset = offset == region.getOffset() ? -1 : region.getOffset();
                }
            }
            catch (BadLocationException badLocationException) {
                found = false;
            }
            catch (BadPartitioningException badPartitioningException) {
                found = false;
            }
        }
        if (found) {
            EditorUtility.revealInEditor((IEditorPart)editor, region);
        } else {
            EditorUtility.revealInEditor((IEditorPart)editor, (int)0, (int)0);
        }
    }

    private static void handleOpenPropertiesFileFailed(IStorage propertiesFile, IEditorPart editor) {
    }

    public static String unwindEscapeChars(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(PropertiesFileHyperlink.getUnwoundString(c));
            ++i;
        }
        return sb.toString();
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~') {
            return "" + '\\' + 'u' + PropertiesFileHyperlink.toHex(c >> 12 & 0xF) + PropertiesFileHyperlink.toHex(c >> 8 & 0xF) + PropertiesFileHyperlink.toHex(c >> 4 & 0xF) + PropertiesFileHyperlink.toHex(c & 0xF);
        }
        return String.valueOf(c);
    }

    private static char toHex(int halfByte) {
        return HEX_DIGITS[halfByte & 0xF];
    }
}

