/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.jdt.search2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.JavaNoTypeCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.xml.search.editor.internal.jdt.search2.JavaContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.internal.util.DocumentHelper;
import org.eclipse.wst.xml.search.editor.java.IJavaReference;
import org.eclipse.wst.xml.search.editor.java.JavaReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;

public class SearchJavaNoTypeCompletionProposalComputer
extends JavaNoTypeCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ArrayList<ICompletionProposal> proposals = null;
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext jcontext = (JavaContentAssistInvocationContext)context;
            try {
                IDocument document;
                DocumentHelper.StringArgument stringArgument;
                IJavaReference javaReference;
                int offset = jcontext.getInvocationOffset();
                IJavaElement element = jcontext.getCompilationUnit().getElementAt(offset);
                if (element != null && (javaReference = JavaReferencesManager.getInstance().getXMLReference(element, (String)null)) != null && (stringArgument = DocumentHelper.findStringArgument(document = jcontext.getDocument(), offset, false)) != null) {
                    IResource resource;
                    IRegion region = stringArgument.getRegion();
                    String matchingString = stringArgument.getMatchingString();
                    if (proposals == null) {
                        proposals = new ArrayList<ICompletionProposal>();
                    }
                    IFile file = (resource = jcontext.getCompilationUnit().getCorrespondingResource()) != null && resource.getType() == 1 ? (IFile)resource : null;
                    List<IXMLReferenceTo> tos = javaReference.getTo();
                    for (IXMLReferenceTo to : tos) {
                        IXMLSearcher searcher = to.getSearcher();
                        if (searcher == null) continue;
                        searcher.searchForCompletion(element, matchingString.toString(), null, null, file, to, new JavaContentAssistProposalRecorder(region, proposals));
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        if (proposals != null) {
            return proposals;
        }
        return Collections.emptyList();
    }

    private String getMatchingString(IDocument document, int offset) {
        StringBuilder s = new StringBuilder("");
        try {
            IRegion li = document.getLineInformationOfOffset(offset);
            int i = offset - 1;
            while (i >= li.getOffset()) {
                if (!document.get(i, 1).equals("\"")) {
                    s.insert(0, document.get(i, 1));
                    --i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return s.toString();
    }
}

