/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.preferences;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.internal.Messages;
import org.eclipse.wst.xml.search.editor.internal.XMLSearchEditorPlugin;
import org.eclipse.wst.xml.search.editor.internal.style.IReferencesStyleConstantsXML;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.w3c.dom.Node;

public class XMLReferencesSyntaxColoringPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IReferencesStyleConstantsXML {
    private Button fColorReferencedEnabled;
    private Button fBold;
    private Label fForegroundLabel;
    private Label fBackgroundLabel;
    private Button fClearStyle;
    private Map fContextToStyleMap;
    private Color fDefaultForeground = null;
    private Color fDefaultBackground = null;
    private IStructuredDocument fDocument;
    private IDOMModel model;
    private ColorSelector fForegroundColorEditor;
    private ColorSelector fBackgroundColorEditor;
    private Button fItalic;
    private OverlayPreferenceStore fOverlayStore;
    private Button fStrike;
    private Collection fStylePreferenceKeys;
    private StructuredViewer fStylesViewer = null;
    private Map fStyleToDescriptionMap;
    private StyledText fText;
    private Button fUnderline;

    private void activate(String namedStyle) {
        Color foreground = this.fDefaultForeground;
        Color background = this.fDefaultBackground;
        if (namedStyle == null) {
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fItalic.setEnabled(false);
            this.fStrike.setEnabled(false);
            this.fUnderline.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
            this.fForegroundColorEditor.setEnabled(false);
            this.fBackgroundColorEditor.setEnabled(false);
            this.fBold.setSelection(false);
            this.fItalic.setSelection(false);
            this.fStrike.setSelection(false);
            this.fUnderline.setSelection(false);
        } else {
            boolean enabled = this.fColorReferencedEnabled.getSelection();
            TextAttribute attribute = this.getAttributeFor(namedStyle);
            this.fClearStyle.setEnabled(enabled);
            this.fBold.setEnabled(enabled);
            this.fItalic.setEnabled(enabled);
            this.fStrike.setEnabled(enabled);
            this.fUnderline.setEnabled(enabled);
            this.fForegroundLabel.setEnabled(enabled);
            this.fBackgroundLabel.setEnabled(enabled);
            this.fForegroundColorEditor.setEnabled(enabled);
            this.fBackgroundColorEditor.setEnabled(enabled);
            this.fBold.setSelection((attribute.getStyle() & 1) != 0);
            this.fItalic.setSelection((attribute.getStyle() & 2) != 0);
            this.fStrike.setSelection((attribute.getStyle() & 0x20000000) != 0);
            this.fUnderline.setSelection((attribute.getStyle() & 0x40000000) != 0);
            if (attribute.getForeground() != null) {
                foreground = attribute.getForeground();
            }
            if (attribute.getBackground() != null) {
                background = attribute.getBackground();
            }
        }
        this.fForegroundColorEditor.setColorValue(foreground.getRGB());
        this.fBackgroundColorEditor.setColorValue(background.getRGB());
    }

    void applyStyles() {
        if (this.fText == null || this.fText.isDisposed()) {
            return;
        }
        boolean applyRef = false;
        IStructuredDocumentRegion[] structuredDocumentRegions = this.model.getStructuredDocument().getStructuredDocumentRegions();
        int j = 0;
        while (j < structuredDocumentRegions.length) {
            IStructuredDocumentRegion documentRegion = structuredDocumentRegions[j];
            ITextRegionList regions = documentRegion.getRegions();
            int i = 0;
            while (i < regions.size()) {
                TextAttribute attribute;
                IDOMNode node;
                ITextRegion currentRegion = regions.get(i);
                String namedStyle = null;
                String type = currentRegion.getType();
                if (type == "XML_TAG_ATTRIBUTE_VALUE") {
                    IDOMAttr attr;
                    applyRef = false;
                    node = DOMUtils.getNodeByOffset((IStructuredModel)this.model, (int)documentRegion.getStart());
                    if (node != null && (attr = DOMUtils.getAttrByOffset((Node)node, (int)(documentRegion.getStart() + currentRegion.getStart()))) != null && attr.getName().startsWith("ref")) {
                        applyRef = true;
                    }
                    namedStyle = applyRef ? "tagReferencedAttributeValue" : (String)this.fContextToStyleMap.get(currentRegion.getType());
                } else if (type == "XML_CONTENT") {
                    Node parent;
                    applyRef = false;
                    node = DOMUtils.getNodeByOffset((IStructuredModel)this.model, (int)documentRegion.getStart());
                    if (node != null && (parent = node.getParentNode()).getNodeName().startsWith("ref")) {
                        applyRef = true;
                    }
                    namedStyle = applyRef ? "xmlReferencedContent" : (String)this.fContextToStyleMap.get(currentRegion.getType());
                } else {
                    namedStyle = (String)this.fContextToStyleMap.get(currentRegion.getType());
                }
                if (namedStyle != null && (attribute = this.getAttributeFor(namedStyle)) != null) {
                    StyleRange style = new StyleRange(documentRegion.getStartOffset(currentRegion), currentRegion.getTextLength(), attribute.getForeground(), attribute.getBackground(), attribute.getStyle());
                    style.strikeout = (attribute.getStyle() & 0x20000000) != 0;
                    style.underline = (attribute.getStyle() & 0x40000000) != 0;
                    this.fText.setStyleRange(style);
                }
                ++i;
            }
            documentRegion = documentRegion.getNext();
            ++j;
        }
    }

    Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fDefaultForeground = parent.getDisplay().getSystemColor(24);
        this.fDefaultBackground = parent.getDisplay().getSystemColor(25);
        Composite pageComponent = this.createComposite(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.wst.xml.ui.webx0062");
        this.fColorReferencedEnabled = this.createCheckbox(pageComponent, Messages.XMLReferencesSyntaxColoringPage_0);
        this.fColorReferencedEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLReferencesSyntaxColoringPage.this.updateEnabled();
            }
        });
        this.fColorReferencedEnabled.setSelection(this.getOverlayStore().getBoolean("enabledColor"));
        Link link = new Link(pageComponent, 64);
        link.setText(SSEUIMessages.SyntaxColoring_Link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData linkData = new GridData(4, 1, true, false, 2, 1);
        linkData.widthHint = 150;
        link.setLayoutData((Object)linkData);
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        new Label(pageComponent, 0).setLayoutData((Object)new GridData());
        SashForm editor = new SashForm(pageComponent, 512);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.horizontalSpan = 2;
        editor.setLayoutData((Object)gridData2);
        SashForm top = new SashForm((Composite)editor, 256);
        Composite styleEditor = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginRight = 5;
        ((GridLayout)styleEditor.getLayout()).marginLeft = 0;
        this.createLabel(styleEditor, XMLUIMessages.SyntaxColoringPage_0);
        this.fStylesViewer = this.createStylesViewer(styleEditor);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 0;
        Iterator iterator = this.fStyleToDescriptionMap.values().iterator();
        while (iterator.hasNext()) {
            gridData.widthHint = Math.max(gridData.widthHint, this.convertWidthInCharsToPixels(iterator.next().toString().length()));
        }
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.fStylesViewer.getControl().setLayoutData((Object)gridData);
        Composite editingComposite = this.createComposite((Composite)top, 1);
        ((GridLayout)styleEditor.getLayout()).marginLeft = 5;
        this.createLabel(editingComposite, "");
        Button enabler = this.createCheckbox(editingComposite, XMLUIMessages.SyntaxColoringPage_2);
        enabler.setEnabled(false);
        enabler.setSelection(true);
        Composite editControls = this.createComposite(editingComposite, 2);
        ((GridLayout)editControls.getLayout()).marginLeft = 20;
        this.fForegroundLabel = this.createLabel(editControls, SSEUIMessages.Foreground_UI_);
        ((GridData)this.fForegroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fForegroundLabel.setEnabled(false);
        this.fForegroundColorEditor = new ColorSelector(editControls);
        Button fForegroundColor = this.fForegroundColorEditor.getButton();
        GridData gd = new GridData(1, 4, false, false);
        fForegroundColor.setLayoutData((Object)gd);
        this.fForegroundColorEditor.setEnabled(false);
        this.fBackgroundLabel = this.createLabel(editControls, SSEUIMessages.Background_UI_);
        ((GridData)this.fBackgroundLabel.getLayoutData()).verticalAlignment = 0x1000000;
        this.fBackgroundLabel.setEnabled(false);
        this.fBackgroundColorEditor = new ColorSelector(editControls);
        Button fBackgroundColor = this.fBackgroundColorEditor.getButton();
        gd = new GridData(1, 4, false, false);
        fBackgroundColor.setLayoutData((Object)gd);
        this.fBackgroundColorEditor.setEnabled(false);
        this.fBold = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_3);
        this.fBold.setEnabled(false);
        ((GridData)this.fBold.getLayoutData()).horizontalSpan = 2;
        this.fItalic = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_4);
        this.fItalic.setEnabled(false);
        ((GridData)this.fItalic.getLayoutData()).horizontalSpan = 2;
        this.fStrike = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_5);
        this.fStrike.setEnabled(false);
        ((GridData)this.fStrike.getLayoutData()).horizontalSpan = 2;
        this.fUnderline = this.createCheckbox(editControls, XMLUIMessages.SyntaxColoringPage_6);
        this.fUnderline.setEnabled(false);
        ((GridData)this.fUnderline.getLayoutData()).horizontalSpan = 2;
        this.fClearStyle = new Button(editingComposite, 8);
        this.fClearStyle.setText(SSEUIMessages.Restore_Default_UI_);
        this.fClearStyle.setLayoutData((Object)new GridData(1));
        ((GridData)this.fClearStyle.getLayoutData()).horizontalIndent = 20;
        this.fClearStyle.setEnabled(false);
        Composite sampleArea = this.createComposite((Composite)editor, 1);
        ((GridLayout)sampleArea.getLayout()).marginLeft = 5;
        ((GridLayout)sampleArea.getLayout()).marginTop = 5;
        this.createLabel(sampleArea, SSEUIMessages.Sample_text__UI_);
        SourceViewer viewer = new SourceViewer(sampleArea, null, 33557258);
        this.fText = viewer.getTextWidget();
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.widthHint = this.convertWidthInCharsToPixels(20);
        gridData3.heightHint = this.convertHeightInCharsToPixels(5);
        gridData3.horizontalSpan = 2;
        this.fText.setLayoutData((Object)gridData3);
        this.fText.setEditable(false);
        this.fText.setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
        this.fDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor(ContentTypeIdForXML.ContentTypeID_XML);
        this.fDocument.set(this.getExampleText());
        this.model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        this.model.setStructuredDocument(this.fDocument);
        viewer.setDocument((IDocument)this.fDocument);
        top.setWeights(new int[]{1, 1});
        editor.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "org.eclipse.wst.xml.ui.webx0062");
        this.fStylesViewer.setInput((Object)this.getStylePreferenceKeys());
        this.applyStyles();
        this.updateEnabled();
        this.fStylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    XMLReferencesSyntaxColoringPage.this.activate(namedStyle);
                    if (namedStyle == null) {
                        return;
                    }
                }
            }
        });
        this.fForegroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[0];
                        String newValue = ColorHelper.toRGBString((RGB)XMLReferencesSyntaxColoringPage.this.fForegroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[0] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            XMLReferencesSyntaxColoringPage.this.applyStyles();
                            XMLReferencesSyntaxColoringPage.this.fText.redraw();
                        }
                    }
                }
            }
        });
        this.fBackgroundColorEditor.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("colorValue")) {
                    Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                    String namedStyle = o.toString();
                    String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                    String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                    if (stylePrefs != null) {
                        String oldValue = stylePrefs[1];
                        String newValue = ColorHelper.toRGBString((RGB)XMLReferencesSyntaxColoringPage.this.fBackgroundColorEditor.getColorValue());
                        if (!newValue.equals(oldValue)) {
                            stylePrefs[1] = newValue;
                            String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                            XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                            XMLReferencesSyntaxColoringPage.this.applyStyles();
                            XMLReferencesSyntaxColoringPage.this.fText.redraw();
                            XMLReferencesSyntaxColoringPage.this.activate(namedStyle);
                        }
                    }
                }
            }
        });
        this.fBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[2];
                    String newValue = String.valueOf(XMLReferencesSyntaxColoringPage.this.fBold.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[2] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XMLReferencesSyntaxColoringPage.this.applyStyles();
                        XMLReferencesSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[3];
                    String newValue = String.valueOf(XMLReferencesSyntaxColoringPage.this.fItalic.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[3] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XMLReferencesSyntaxColoringPage.this.applyStyles();
                        XMLReferencesSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fStrike.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[4];
                    String newValue = String.valueOf(XMLReferencesSyntaxColoringPage.this.fStrike.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[4] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XMLReferencesSyntaxColoringPage.this.applyStyles();
                        XMLReferencesSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fUnderline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Object o = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement();
                String namedStyle = o.toString();
                String prefString = XMLReferencesSyntaxColoringPage.this.getOverlayStore().getString(namedStyle);
                String[] stylePrefs = ColorHelper.unpackStylePreferences((String)prefString);
                if (stylePrefs != null) {
                    String oldValue = stylePrefs[5];
                    String newValue = String.valueOf(XMLReferencesSyntaxColoringPage.this.fUnderline.getSelection());
                    if (!newValue.equals(oldValue)) {
                        stylePrefs[5] = newValue;
                        String newPrefString = ColorHelper.packStylePreferences((String[])stylePrefs);
                        XMLReferencesSyntaxColoringPage.this.getOverlayStore().setValue(namedStyle, newPrefString);
                        XMLReferencesSyntaxColoringPage.this.applyStyles();
                        XMLReferencesSyntaxColoringPage.this.fText.redraw();
                    }
                }
            }
        });
        this.fClearStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection().isEmpty()) {
                    return;
                }
                String namedStyle = ((IStructuredSelection)XMLReferencesSyntaxColoringPage.this.fStylesViewer.getSelection()).getFirstElement().toString();
                XMLReferencesSyntaxColoringPage.this.getOverlayStore().setToDefault(namedStyle);
                XMLReferencesSyntaxColoringPage.this.applyStyles();
                XMLReferencesSyntaxColoringPage.this.fText.redraw();
                XMLReferencesSyntaxColoringPage.this.activate(namedStyle);
            }
        });
        return pageComponent;
    }

    private void updateEnabled() {
        boolean enabled = this.fColorReferencedEnabled.getSelection();
        this.fStylesViewer.getControl().setEnabled(enabled);
        this.getOverlayStore().setValue("enabledColor", enabled);
        if (enabled) {
            ISelection selection = this.fStylesViewer.getSelection();
            if (selection.isEmpty()) {
                this.activate(null);
            } else {
                String namedStyle = (String)((IStructuredSelection)selection).getFirstElement();
                this.activate(namedStyle);
            }
        } else {
            this.activate(null);
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        label.setBackground(parent.getBackground());
        return label;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator i = this.getStylePreferenceKeys().iterator();
        while (i.hasNext()) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, (String)i.next()));
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "enabledColor"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private StructuredViewer createStylesViewer(Composite parent) {
        ListViewer stylesViewer = new ListViewer(parent, 2820);
        stylesViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object description = XMLReferencesSyntaxColoringPage.this.fStyleToDescriptionMap.get(element);
                if (description != null) {
                    return description.toString();
                }
                return super.getText(element);
            }
        });
        stylesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return XMLReferencesSyntaxColoringPage.this.getStylePreferenceKeys().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return XMLReferencesSyntaxColoringPage.this.getStylePreferenceKeys();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        return stylesViewer;
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
        }
        super.dispose();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XMLSearchEditorPlugin.getDefault().getPreferenceStore();
    }

    private TextAttribute getAttributeFor(String namedStyle) {
        String prefString;
        String[] stylePrefs;
        TextAttribute ta = new TextAttribute(this.fDefaultForeground, this.fDefaultBackground, 0);
        Object colorPreferences = null;
        if (namedStyle != null && this.fOverlayStore != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = (colorPreferences = "tagReferencedAttributeValue".equals(namedStyle) || "xmlReferencedContent".equals(namedStyle) ? this.getOverlayStore() : XMLUIPlugin.getDefault().getPreferenceStore()).getString(namedStyle)))) != null) {
            boolean on;
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            int fontModifier = 0;
            if (stylePrefs.length > 2 && (on = Boolean.valueOf(stylePrefs[2]).booleanValue())) {
                fontModifier |= 1;
            }
            if (stylePrefs.length > 3 && (on = Boolean.valueOf(stylePrefs[3]).booleanValue())) {
                fontModifier |= 2;
            }
            if (stylePrefs.length > 4 && (on = Boolean.valueOf(stylePrefs[4]).booleanValue())) {
                fontModifier |= 0x20000000;
            }
            if (stylePrefs.length > 5 && (on = Boolean.valueOf(stylePrefs[5]).booleanValue())) {
                fontModifier |= 0x40000000;
            }
            ta = new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, fontModifier);
        }
        return ta;
    }

    private String getExampleText() {
        return Messages.Sample_XML_doc;
    }

    private String getNamedStyleAtOffset(int offset) {
        IDOMText text;
        Node parent;
        IndexedRegion indexedRegion = this.model.getIndexedRegion(offset);
        if (indexedRegion instanceof IDOMAttr) {
            IDOMAttr attr = (IDOMAttr)indexedRegion;
            if (attr.getName().startsWith("ref")) {
                return "tagReferencedAttributeValue";
            }
        } else if (indexedRegion instanceof IDOMText && (parent = (text = (IDOMText)indexedRegion).getParentNode()).getNodeName().startsWith("ref")) {
            return "xmlReferencedContent";
        }
        if (offset >= this.fDocument.getLength()) {
            return this.getNamedStyleAtOffset(this.fDocument.getLength() - 1);
        }
        if (offset < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        IStructuredDocumentRegion documentRegion = this.fDocument.getFirstStructuredDocumentRegion();
        while (documentRegion != null && !documentRegion.containsOffset(offset)) {
            documentRegion = documentRegion.getNext();
        }
        if (documentRegion != null) {
            ITextRegion interest = documentRegion.getRegionAtCharacterOffset(offset);
            if (interest == null) {
                return null;
            }
            if (offset > documentRegion.getTextEndOffset(interest)) {
                return null;
            }
            String regionContext = interest.getType();
            if (regionContext == null) {
                return null;
            }
            String namedStyle = (String)this.fContextToStyleMap.get(regionContext);
            if (namedStyle != null) {
                return namedStyle;
            }
        }
        return null;
    }

    private OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    private Collection getStylePreferenceKeys() {
        if (this.fStylePreferenceKeys == null) {
            ArrayList<String> styles = new ArrayList<String>();
            styles.add("tagReferencedAttributeValue");
            styles.add("xmlReferencedContent");
            this.fStylePreferenceKeys = styles;
        }
        return this.fStylePreferenceKeys;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XMLReferencesSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XMLReferencesSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.widget instanceof StyledText) {
                    int x = ((StyledText)e.widget).getCaretOffset();
                    XMLReferencesSyntaxColoringPage.this.selectColorAtOffset(x);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XMLReferencesSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                XMLReferencesSyntaxColoringPage.this.selectColorAtOffset(e.x);
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).setSelection(e.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.widget instanceof StyledText && (e.detail == 16 || e.detail == 8)) {
                    e.doit = true;
                }
            }
        };
    }

    public void init(IWorkbench workbench) {
        this.setDescription(SSEUIMessages.SyntaxColoring_Description);
        this.fStyleToDescriptionMap = new HashMap();
        this.fContextToStyleMap = new HashMap();
        this.initStyleToDescriptionMap();
        this.initRegionContextToStyleMap();
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    private void initRegionContextToStyleMap() {
        this.fContextToStyleMap.put("XML_COMMENT_OPEN", "commentBorder");
        this.fContextToStyleMap.put("XML_COMMENT_TEXT", "commentText");
        this.fContextToStyleMap.put("XML_COMMENT_CLOSE", "commentBorder");
        this.fContextToStyleMap.put("XML_TAG_OPEN", "tagBorder");
        this.fContextToStyleMap.put("XML_END_TAG_OPEN", "tagBorder");
        this.fContextToStyleMap.put("XML_TAG_NAME", "tagName");
        this.fContextToStyleMap.put("XML_TAG_ATTRIBUTE_NAME", "tagAttributeName");
        this.fContextToStyleMap.put("XML_TAG_ATTRIBUTE_VALUE", "tagAttributeValue");
        this.fContextToStyleMap.put("XML_TAG_CLOSE", "tagBorder");
        this.fContextToStyleMap.put("XML_EMPTY_TAG_CLOSE", "tagBorder");
        this.fContextToStyleMap.put("XML_DECLARATION_OPEN", "declBoder");
        this.fContextToStyleMap.put("XML_DECLARATION_CLOSE", "declBoder");
        this.fContextToStyleMap.put("XML_ELEMENT_DECLARATION", "declBoder");
        this.fContextToStyleMap.put("XML_ELEMENT_DECL_CLOSE", "declBoder");
        this.fContextToStyleMap.put("XML_CONTENT", "xmlContent");
        this.fContextToStyleMap.put("XML_CDATA_OPEN", "cdataBorder");
        this.fContextToStyleMap.put("XML_CDATA_TEXT", "cdataText");
        this.fContextToStyleMap.put("XML_CDATA_CLOSE", "cdataBorder");
        this.fContextToStyleMap.put("XML_PI_OPEN", "piBorder");
        this.fContextToStyleMap.put("XML_PI_CONTENT", "piContent");
        this.fContextToStyleMap.put("XML_PI_CLOSE", "piBorder");
        this.fContextToStyleMap.put("XML_ELEMENT_DECL_NAME", "doctypeName");
        this.fContextToStyleMap.put("XML_DOCTYPE_DECLARATION", "tagName");
        this.fContextToStyleMap.put("XML_DOCTYPE_DECLARATION_CLOSE", "declBoder");
        this.fContextToStyleMap.put("XML_DOCTYPE_NAME", "doctypeName");
        this.fContextToStyleMap.put("XML_DOCTYPE_EXTERNAL_ID_PUBLIC", "doctypeExternalId");
        this.fContextToStyleMap.put("XML_DOCTYPE_EXTERNAL_ID_PUBREF", "doctypeExternalPubref");
        this.fContextToStyleMap.put("XML_DOCTYPE_EXTERNAL_ID_SYSTEM", "doctypeExternalId");
        this.fContextToStyleMap.put("XML_DOCTYPE_EXTERNAL_ID_SYSREF", "doctypeExtrenalSysref");
        this.fContextToStyleMap.put("XML_CHAR_REFERENCE", "entityReference");
        this.fContextToStyleMap.put("XML_ENTITY_REFERENCE", "entityReference");
        this.fContextToStyleMap.put("XML_PE_REFERENCE", "entityReference");
    }

    private void initStyleToDescriptionMap() {
        this.fStyleToDescriptionMap.put("cdataBorder", XMLUIMessages.CDATA_Delimiters_UI_);
        this.fStyleToDescriptionMap.put("cdataText", XMLUIMessages.CDATA_Content_UI_);
        this.fStyleToDescriptionMap.put("piBorder", XMLUIMessages.Processing_Instruction_Del_UI_);
        this.fStyleToDescriptionMap.put("piContent", XMLUIMessages.Processing_Instruction_Con_UI__UI_);
        this.fStyleToDescriptionMap.put("commentBorder", XMLUIMessages.Comment_Delimiters_UI_);
        this.fStyleToDescriptionMap.put("commentText", XMLUIMessages.Comment_Content_UI_);
        this.fStyleToDescriptionMap.put("tagBorder", XMLUIMessages.Tag_Delimiters_UI_);
        this.fStyleToDescriptionMap.put("tagName", XMLUIMessages.Tag_Names_UI_);
        this.fStyleToDescriptionMap.put("tagAttributeName", XMLUIMessages.Attribute_Names_UI_);
        this.fStyleToDescriptionMap.put("tagAttributeValue", XMLUIMessages.Attribute_Values_UI_);
        this.fStyleToDescriptionMap.put("declBoder", XMLUIMessages.Declaration_Delimiters_UI_);
        this.fStyleToDescriptionMap.put("xmlContent", XMLUIMessages.Content_UI_);
        this.fStyleToDescriptionMap.put("doctypeName", XMLUIMessages.DOCTYPE_Name_UI_);
        this.fStyleToDescriptionMap.put("doctypeExternalId", XMLUIMessages.DOCTYPE_SYSTEM_PUBLIC_Keyw_UI_);
        this.fStyleToDescriptionMap.put("doctypeExternalPubref", XMLUIMessages.DOCTYPE_Public_Reference_UI_);
        this.fStyleToDescriptionMap.put("doctypeExtrenalSysref", XMLUIMessages.DOCTYPE_System_Reference_UI_);
        this.fStyleToDescriptionMap.put("entityReference", XMLUIMessages.Entity_Reference_UI_);
        this.fStyleToDescriptionMap.put("tagReferencedAttributeValue", Messages.Referenced_Attribute_Values_UI_);
        this.fStyleToDescriptionMap.put("xmlReferencedContent", Messages.Referenced_Content_UI_);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getOverlayStore().loadDefaults();
        this.fColorReferencedEnabled.setSelection(this.getOverlayStore().getBoolean("enabledColor"));
        this.updateEnabled();
        this.applyStyles();
        this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.activate(null);
        this.fText.redraw();
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        XMLSearchEditorPlugin.getDefault().savePluginPreferences();
        SSEUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void selectColorAtOffset(int offset) {
        String namedStyle = this.getNamedStyleAtOffset(offset);
        if (namedStyle != null) {
            this.fStylesViewer.setSelection((ISelection)new StructuredSelection((Object)namedStyle));
            this.fStylesViewer.reveal((Object)namedStyle);
        } else {
            this.fStylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.activate(namedStyle);
    }

    private void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    static /* synthetic */ void access$0(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        xMLReferencesSyntaxColoringPage.updateEnabled();
    }

    static /* synthetic */ void access$1(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage, String string) {
        xMLReferencesSyntaxColoringPage.activate(string);
    }

    static /* synthetic */ StructuredViewer access$2(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fStylesViewer;
    }

    static /* synthetic */ OverlayPreferenceStore access$3(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.getOverlayStore();
    }

    static /* synthetic */ ColorSelector access$4(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fForegroundColorEditor;
    }

    static /* synthetic */ StyledText access$5(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fText;
    }

    static /* synthetic */ ColorSelector access$6(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fBackgroundColorEditor;
    }

    static /* synthetic */ Button access$7(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fBold;
    }

    static /* synthetic */ Button access$8(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fItalic;
    }

    static /* synthetic */ Button access$9(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fStrike;
    }

    static /* synthetic */ Button access$10(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fUnderline;
    }

    static /* synthetic */ Map access$11(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.fStyleToDescriptionMap;
    }

    static /* synthetic */ Collection access$12(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage) {
        return xMLReferencesSyntaxColoringPage.getStylePreferenceKeys();
    }

    static /* synthetic */ void access$13(XMLReferencesSyntaxColoringPage xMLReferencesSyntaxColoringPage, int n) {
        xMLReferencesSyntaxColoringPage.selectColorAtOffset(n);
    }
}

