/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToExpression;
import org.eclipse.wst.xml.search.editor.references.filters.IXMLReferenceFilter;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.expressions.IXMLExpressionParser;

public class XMLReferenceToExpression
extends XMLReference
implements IXMLReferenceToExpression {
    private final IXMLExpressionParser parser;
    private final IXMLSearcher expressionSearcher;
    private final Map<String, List<IXMLReferenceTo>> tokens;

    public XMLReferenceToExpression(String fromPath, String fromTargetNodes, Namespaces namespaces, String querySpecificationId, String[] contentTypeIds, IXMLReferenceFilter filter, IXMLReferenceValidator validator, IXMLExpressionParser parser, IXMLSearcher expressionSearcher) {
        super(fromPath, fromTargetNodes, namespaces, querySpecificationId, contentTypeIds, filter, validator);
        this.parser = parser;
        this.expressionSearcher = expressionSearcher;
        this.tokens = new HashMap<String, List<IXMLReferenceTo>>();
    }

    @Override
    public IXMLReferenceTo.ToType getType() {
        return IXMLReferenceTo.ToType.EXPRESSION;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public IXMLReference getOwnerReference() {
        return this;
    }

    @Override
    public String getQuerySpecificationId() {
        return null;
    }

    @Override
    public IXMLSearcher getSearcher() {
        return this.expressionSearcher;
    }

    @Override
    public IXMLExpressionParser getParser() {
        return this.parser;
    }

    @Override
    public IXMLReference addTo(IXMLReferenceTo to) {
        String tokenId = to.getTokenId();
        if (!StringUtils.isEmpty((String)tokenId)) {
            List<IXMLReferenceTo> tos = this.tokens.get(tokenId);
            if (tos == null) {
                tos = new ArrayList<IXMLReferenceTo>();
                this.tokens.put(tokenId, tos);
            }
            tos.add(to);
        }
        return super.addTo(to);
    }

    @Override
    public List<IXMLReferenceTo> getTo(String tokenId) {
        List<IXMLReferenceTo> tos = this.tokens.get(tokenId);
        if (tos != null) {
            return tos;
        }
        return Collections.emptyList();
    }

    @Override
    public String getTokenId() {
        return null;
    }

    @Override
    public boolean isExpression() {
        return true;
    }
}

