/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.searchers.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.searchers.java.JavaQuerySpecification;
import org.eclipse.wst.xml.search.editor.searchers.java.IJavaQuerySpecification;

public class JavaQuerySpecificationrManager
extends AbstractRegistryManager {
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String QUERY_SPECIFICATION_ELT = "querySpecification";
    public static final JavaQuerySpecificationrManager INSTANCE = new JavaQuerySpecificationrManager();
    private static final String JAVA_QUERY_SPECIFICATIONS_EXTENSION_POINT = "javaQuerySpecifications";
    private Map<String, IJavaQuerySpecification> querySpecificationById = null;

    public static JavaQuerySpecificationrManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.querySpecificationById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addJavaFilter(this.querySpecificationById, cf);
        }
    }

    private synchronized void addJavaFilter(Map<String, IJavaQuerySpecification> querySpecificationById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (QUERY_SPECIFICATION_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    Object o = ce.createExecutableExtension(CLASS_ATTR);
                    IJavaQuerySpecification querySpecification = JavaQuerySpecification.newJavaQuerySpecification(o);
                    if (querySpecification != null) {
                        querySpecificationById.put(id, querySpecification);
                    }
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load javaQuerySpecification for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IJavaQuerySpecification getQuerySpecification(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (this.querySpecificationById == null) {
            this.loadQuerySpecifications();
        }
        return this.querySpecificationById.get(id);
    }

    private synchronized void loadQuerySpecifications() {
        if (this.querySpecificationById != null) {
            return;
        }
        HashMap<String, IJavaQuerySpecification> querySpecificationById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", JAVA_QUERY_SPECIFICATIONS_EXTENSION_POINT);
            querySpecificationById = new HashMap(cf.length);
            this.addJavaFilter(querySpecificationById, cf);
        } else {
            querySpecificationById = new HashMap<String, IJavaQuerySpecification>();
        }
        this.querySpecificationById = querySpecificationById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return JAVA_QUERY_SPECIFICATIONS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

