/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class BaseLiferayProject
implements ILiferayProject {
    private IProject project;

    public BaseLiferayProject(IProject project) {
        this.project = project;
    }

    @Override
    public <T> T adapt(Class<T> adapterType) {
        Object[] adapters = LiferayCore.getProjectAdapters();
        if (!CoreUtil.isNullOrEmpty(adapters)) {
            Object[] objectArray = adapters;
            int n = adapters.length;
            int n2 = 0;
            while (n2 < n) {
                Object adapter = objectArray[n2];
                T adapted = adapter.adapt(this, adapterType);
                if (adapted != null) {
                    return adapted;
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean filterResource(IPath resourcePath, String[] ignorePaths) {
        if (resourcePath == null || resourcePath.segmentCount() < 1) {
            return false;
        }
        String[] stringArray = ignorePaths;
        int n = ignorePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String ignorePath = stringArray[n2];
            if (resourcePath.segment(0).equals(ignorePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public IFolder getSourceFolder(String classification) {
        List<IFolder> folders = CoreUtil.getSourceFolders(JavaCore.create((IProject)this.project));
        if (!CoreUtil.isNullOrEmpty(folders)) {
            return folders.get(0);
        }
        return null;
    }

    @Override
    public IFolder[] getSourceFolders() {
        IFolder[] retval = null;
        try {
            IJavaProject javaproject;
            IProject project = this.getProject();
            if (project != null && (javaproject = JavaCore.create((IProject)project)) != null && javaproject.exists()) {
                if (!javaproject.isOpen()) {
                    javaproject.open((IProgressMonitor)new NullProgressMonitor());
                }
                retval = CoreUtil.getSourceFolders(javaproject).toArray(new IFolder[0]);
            }
        }
        catch (JavaModelException e) {
            LiferayCore.logWarning(e);
        }
        return retval;
    }
}

