/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IResourceBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PropertiesUtil {
    public static final String ELEMENT_LANGUAGE_PROPERTIES = "language-properties";
    public static final String ELEMENT_PORTAL_PROPERTIES = "portal-properties";
    public static final String ELEMENT_PORTLET = "portlet";
    public static final String ELEMENT_RESOURCE_BUNDLE = "resource-bundle";
    public static final String ELEMENT_SUPPORTED_LOCALE = "supported-locale";
    public static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static LanguageFileInfo tmpLanguageFileInfo = null;
    private static ResourceNodeInfo tmpResourceNodeInfo = null;

    public static void encodeLanguagePropertiesFilesToDefault(IResource resource, IProgressMonitor monitor) {
        if (resource.getType() == 4) {
            IFile[] languagePropertiesFiles;
            IFile[] iFileArray = languagePropertiesFiles = PropertiesUtil.getAllLanguagePropertiesFiles((IProject)resource);
            int n = languagePropertiesFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                PropertiesUtil.encodeLanguagePropertyFile(file, monitor);
                ++n2;
            }
        } else if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            PropertiesUtil.encodeLanguagePropertyFile(file, monitor);
        }
    }

    private static void encodeLanguagePropertyFile(IFile file, IProgressMonitor monitor) {
        try {
            String contents = CoreUtil.readStreamToString(file.getContents());
            file.setCharset(null, monitor);
            file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes("UTF-8")), 1, monitor);
        }
        catch (Exception e) {
            LiferayCore.logError(e);
        }
    }

    public static String[] generatePropertiesNamePatternsForEncoding(String baseValue, String elementName) {
        baseValue = baseValue.replaceAll("(^\\s*)|(\\s*$)", "");
        String regex = null;
        if (elementName.equals(ELEMENT_RESOURCE_BUNDLE)) {
            if (baseValue.endsWith(PROPERTIES_FILE_SUFFIX) || baseValue.contains("/") || CoreUtil.isWindows() && baseValue.contains("\\")) {
                return new String[0];
            }
            if (!(baseValue = new Path(baseValue.replace(".", "/")).toString()).contains("_")) {
                regex = String.valueOf(baseValue) + "_.*";
            }
        } else if (elementName.equals(ELEMENT_LANGUAGE_PROPERTIES)) {
            if (!baseValue.endsWith(PROPERTIES_FILE_SUFFIX)) {
                return new String[0];
            }
            if ((baseValue = new Path(baseValue.replace(PROPERTIES_FILE_SUFFIX, "")).toString()).contains("*")) {
                regex = baseValue.replace("*", ".*");
                baseValue = null;
            } else if (!baseValue.contains("_")) {
                regex = String.valueOf(baseValue) + "_.*";
            }
        }
        String[] retval = new String[]{baseValue, regex};
        return retval;
    }

    public static String[] generatePropertiesNamePatternsForValidation(String baseValue, String elementName) {
        String regex = null;
        if (elementName.equals(ELEMENT_RESOURCE_BUNDLE)) {
            baseValue = new Path(baseValue.replace(".", "/")).toString();
        } else if (elementName.equals(ELEMENT_PORTAL_PROPERTIES)) {
            baseValue = new Path(baseValue.replace(PROPERTIES_FILE_SUFFIX, "")).toString();
        } else if (elementName.equals(ELEMENT_LANGUAGE_PROPERTIES) && (baseValue = new Path(baseValue.replace(PROPERTIES_FILE_SUFFIX, "")).toString()).contains("*")) {
            regex = baseValue.replace("*", ".*");
            baseValue = null;
        }
        String[] retval = new String[]{baseValue, regex};
        return retval;
    }

    public static IFile[] getAllLanguagePropertiesFiles(IProject project) {
        ArrayList<IFile> retval = new ArrayList<IFile>();
        if (!CoreUtil.isLiferayProject(project)) {
            project = CoreUtil.getLiferayProject((IResource)project);
        }
        ILiferayProject lrproject = LiferayCore.create(project);
        IFile[] resourceFiles = PropertiesUtil.getLanguagePropertiesFromPortletXml(lrproject.getDescriptorFile("portlet.xml"));
        IFile[] languageFiles = PropertiesUtil.getLanguagePropertiesFromLiferayHookXml(lrproject.getDescriptorFile("liferay-hook.xml"));
        if (resourceFiles.length > 0) {
            retval.addAll(Arrays.asList(resourceFiles));
        }
        if (languageFiles.length > 0) {
            retval.addAll(Arrays.asList(languageFiles));
        }
        return retval.toArray(new IFile[0]);
    }

    public static List<IFile> getDefaultLanguagePropertiesFromModuleProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType portletType = null;
        ArrayList<IFile> retvals = new ArrayList<IFile>();
        try {
            IType[] subTypes;
            int n;
            IType[] iTypeArray;
            IType[] javaElements;
            portletType = javaProject.findType("javax.portlet.Portlet");
            ITypeHierarchy typeHierarchy = portletType.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
            IPackageFragmentRoot[] packageRoots = javaProject.getPackageFragmentRoots();
            ArrayList<String> packages = new ArrayList<String>();
            ArrayList<IType> srcJavaTypes = new ArrayList<IType>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
            int n2 = packageRoots.length;
            int n3 = 0;
            while (n3 < n2) {
                IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n3];
                if (packageRoot.getKind() == 1) {
                    iTypeArray = javaElements = packageRoot.getChildren();
                    n = javaElements.length;
                    int n4 = 0;
                    while (n4 < n) {
                        IType javaElement = iTypeArray[n4];
                        IPackageFragment packageFragment = (IPackageFragment)javaElement;
                        packages.add(packageFragment.getElementName());
                        ++n4;
                    }
                }
                ++n3;
            }
            javaElements = subTypes = typeHierarchy.getAllSubtypes(portletType);
            int n5 = subTypes.length;
            n2 = 0;
            while (n2 < n5) {
                IType type = javaElements[n2];
                if (PropertiesUtil.isInPackage(packages, type.getFullyQualifiedName())) {
                    srcJavaTypes.add(type);
                }
                ++n2;
            }
            String resourceBundleValue = null;
            for (IType type : srcJavaTypes) {
                String key;
                File file = type.getResource().getLocation().toFile();
                String content = FileUtil.readContents(file);
                int i = content.indexOf(key = "javax.portlet.resource-bundle=");
                if (i == -1) continue;
                i += key.length();
                StringBuilder strBuilder = new StringBuilder();
                while (i < content.length()) {
                    char ch = content.charAt(i);
                    if (ch == '\"') break;
                    strBuilder.append(ch);
                    ++i;
                }
                resourceBundleValue = strBuilder.toString();
                break;
            }
            String resourceBundle = resourceBundleValue.replaceAll("(^\\s*)|(\\s*$)", "");
            if (!(resourceBundle.endsWith(PROPERTIES_FILE_SUFFIX) || resourceBundle.contains("/") || CoreUtil.isWindows() && resourceBundle.contains("\\"))) {
                resourceBundle = new Path(resourceBundle.replace(".", "/")).toString();
            }
            ILiferayProject lrproject = LiferayCore.create(project);
            IFolder[] srcFolders = lrproject.getSourceFolders();
            iTypeArray = srcFolders;
            n = srcFolders.length;
            int n6 = 0;
            while (n6 < n) {
                IType srcFolder = iTypeArray[n6];
                IFile languageFile = CoreUtil.getWorkspaceRoot().getFile(srcFolder.getFullPath().append(String.valueOf(resourceBundle) + PROPERTIES_FILE_SUFFIX));
                if (languageFile != null && languageFile.exists()) {
                    retvals.add(languageFile);
                }
                ++n6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retvals;
    }

    public static List<IFile> getDefaultLanguagePropertiesFromPortletXml(IFile portletXml) {
        IProject proj = CoreUtil.getLiferayProject((IResource)portletXml);
        if (proj == null) {
            return Collections.emptyList();
        }
        ArrayList<IFile> retvals = new ArrayList<IFile>();
        if (portletXml != null && portletXml.exists()) {
            ILiferayProject lrproject = LiferayCore.create(proj);
            IFolder[] srcFolders = lrproject.getSourceFolders();
            ResourceNodeInfo resourceNodeInfo = PropertiesUtil.getResourceNodeInfo(portletXml);
            Set<String> resourceBundles = resourceNodeInfo.getResourceBundles();
            if (resourceBundles != null && resourceBundles.size() > 0) {
                int i = 0;
                while (i < resourceBundles.size()) {
                    String resourceBundleValue = (String)resourceBundles.toArray()[i];
                    IFolder[] iFolderArray = srcFolders;
                    int n = srcFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder srcFolder = iFolderArray[n2];
                        IFile languageFile = CoreUtil.getWorkspaceRoot().getFile(srcFolder.getFullPath().append(String.valueOf(resourceBundleValue) + PROPERTIES_FILE_SUFFIX));
                        if (languageFile != null && languageFile.exists()) {
                            retvals.add(languageFile);
                        }
                        ++n2;
                    }
                    ++i;
                }
            }
        }
        return retvals;
    }

    public static List<IFile> getDefaultLanguagePropertiesFromProject(IProject project) {
        IResourceBundleProject resourceBundleProject = LiferayCore.create(IResourceBundleProject.class, project);
        if (resourceBundleProject != null) {
            return resourceBundleProject.getDefaultLanguageProperties();
        }
        return Collections.emptyList();
    }

    private static synchronized LanguageFileInfo getLanguageFileInfo(IFile liferayHookXml) {
        if (tmpLanguageFileInfo == null || !tmpLanguageFileInfo.getLiferayHookXml().equals((Object)liferayHookXml) || tmpLanguageFileInfo.getModificationStamp() != liferayHookXml.getModificationStamp()) {
            final LanguageFileInfo retval = new LanguageFileInfo(liferayHookXml);
            try {
                DefaultHandler handler = new DefaultHandler(){
                    boolean isLangPropElem = false;

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        String languagePropertiesValue;
                        if (this.isLangPropElem && (languagePropertiesValue = new String(ch, start, length)).endsWith(PropertiesUtil.PROPERTIES_FILE_SUFFIX)) {
                            String[] languagePropertiesPatterns;
                            String[] stringArray = languagePropertiesPatterns = PropertiesUtil.generatePropertiesNamePatternsForEncoding(languagePropertiesValue, PropertiesUtil.ELEMENT_LANGUAGE_PROPERTIES);
                            int n = languagePropertiesPatterns.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String pattern = stringArray[n2];
                                if (pattern != null) {
                                    retval.addLanguagePropertiesPattern(pattern);
                                }
                                ++n2;
                            }
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (qName.equals(PropertiesUtil.ELEMENT_LANGUAGE_PROPERTIES)) {
                            this.isLangPropElem = false;
                        }
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName.equals(PropertiesUtil.ELEMENT_LANGUAGE_PROPERTIES)) {
                            this.isLangPropElem = true;
                        }
                    }
                };
                InputStream contents = liferayHookXml.getContents();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                saxParser.parse(contents, handler);
                contents.close();
            }
            catch (Exception e) {
                LiferayCore.logError("Error resolving liferay-hook.xml", e);
            }
            tmpLanguageFileInfo = retval;
        }
        return tmpLanguageFileInfo;
    }

    public static IFile[] getLanguagePropertiesFromLiferayHookXml(IFile liferayHookXml) {
        ArrayList<IFile> retval = new ArrayList<IFile>();
        IProject proj = CoreUtil.getLiferayProject((IResource)liferayHookXml);
        if (proj == null) {
            return new IFile[0];
        }
        ILiferayProject lrproject = LiferayCore.create(proj);
        Object[] srcFolders = lrproject.getSourceFolders();
        if (CoreUtil.isNullOrEmpty(srcFolders)) {
            return new IFile[0];
        }
        if (liferayHookXml != null && liferayHookXml.exists()) {
            LanguageFileInfo languageFileInfo = PropertiesUtil.getLanguageFileInfo(liferayHookXml);
            String[] stringArray = languageFileInfo.getLanguagePropertyPatterns();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String languagePropertiesVal = stringArray[n2];
                Object[] objectArray = srcFolders;
                int n3 = srcFolders.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile[] languagePropertiesFiles;
                    Object srcFolder = objectArray[n4];
                    if (srcFolder.exists() && (languagePropertiesFiles = PropertiesUtil.visitPropertiesFiles((IResource)srcFolder, languagePropertiesVal)) != null && languagePropertiesFiles.length > 0) {
                        retval.addAll(Arrays.asList(languagePropertiesFiles));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return retval.toArray(new IFile[0]);
    }

    public static IFile[] getLanguagePropertiesFromPortletXml(IFile portletXml) {
        ArrayList<IFile> retval = new ArrayList<IFile>();
        IProject proj = CoreUtil.getLiferayProject((IResource)portletXml);
        if (proj == null) {
            return new IFile[0];
        }
        ILiferayProject lrproject = LiferayCore.create(proj);
        Object[] srcFolders = lrproject.getSourceFolders();
        if (CoreUtil.isNullOrEmpty(srcFolders)) {
            return new IFile[0];
        }
        if (portletXml != null && portletXml.exists()) {
            Object[] objectArray = srcFolders;
            int n = srcFolders.length;
            int n2 = 0;
            while (n2 < n) {
                Object srcFolder = objectArray[n2];
                if (srcFolder != null && srcFolder.exists()) {
                    ResourceNodeInfo resourceNodeInfo = PropertiesUtil.getResourceNodeInfo(portletXml);
                    String[] stringArray = resourceNodeInfo.getResourceBundlePatterns();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String resourceBundleValue = stringArray[n4];
                        IFile[] resourceBundleFiles = PropertiesUtil.visitPropertiesFiles((IResource)srcFolder, resourceBundleValue);
                        if (resourceBundleFiles != null && resourceBundleFiles.length > 0) {
                            retval.addAll(Arrays.asList(resourceBundleFiles));
                        }
                        ++n4;
                    }
                    stringArray = resourceNodeInfo.getSupportedLocalePatterns();
                    n3 = stringArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        String supportedLocaleValue = stringArray[n4];
                        IFile[] supportedLocaleFiles = PropertiesUtil.visitPropertiesFiles((IResource)srcFolder, supportedLocaleValue);
                        if (supportedLocaleFiles != null && supportedLocaleFiles.length > 0) {
                            retval.addAll(Arrays.asList(supportedLocaleFiles));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return retval.toArray(new IFile[0]);
    }

    private static synchronized ResourceNodeInfo getResourceNodeInfo(IFile portletXml) {
        if (tmpResourceNodeInfo == null || !tmpResourceNodeInfo.getPortletXml().equals((Object)portletXml) || tmpResourceNodeInfo.getModificationStamp() != portletXml.getModificationStamp()) {
            final ResourceNodeInfo retval = new ResourceNodeInfo(portletXml);
            try {
                DefaultHandler handler = new DefaultHandler(){
                    boolean isResourceBundleElem = false;
                    boolean isSupportedLocaleElem = false;
                    String resourceBundleValue = null;
                    final List<String> supportedLocaleValues = new ArrayList<String>();

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.isSupportedLocaleElem) {
                            this.supportedLocaleValues.add(new String(ch, start, length));
                        }
                        if (this.isResourceBundleElem) {
                            this.resourceBundleValue = new String(ch, start, length);
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (qName.equals(PropertiesUtil.ELEMENT_RESOURCE_BUNDLE)) {
                            this.isResourceBundleElem = false;
                        }
                        if (qName.equals(PropertiesUtil.ELEMENT_SUPPORTED_LOCALE)) {
                            this.isSupportedLocaleElem = false;
                        }
                        if (qName.equals(PropertiesUtil.ELEMENT_PORTLET)) {
                            if (!CoreUtil.isNullOrEmpty(this.resourceBundleValue)) {
                                String resourceBundle;
                                String[] resourceBundlesPatterns;
                                String[] stringArray = resourceBundlesPatterns = PropertiesUtil.generatePropertiesNamePatternsForEncoding(this.resourceBundleValue, PropertiesUtil.ELEMENT_RESOURCE_BUNDLE);
                                int n = resourceBundlesPatterns.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String pattern = stringArray[n2];
                                    if (!CoreUtil.isNullOrEmpty(pattern)) {
                                        retval.addResourceBundlePattern(pattern);
                                    }
                                    ++n2;
                                }
                                if (this.supportedLocaleValues.size() > 0 && resourceBundlesPatterns.length > 0) {
                                    String resourceBundleValueBase = resourceBundlesPatterns[0];
                                    for (String supportedLocaleValue : this.supportedLocaleValues) {
                                        retval.addSupportedLocalePattern(String.valueOf(resourceBundleValueBase) + "_" + supportedLocaleValue);
                                    }
                                }
                                if (!((resourceBundle = this.resourceBundleValue.replaceAll("(^\\s*)|(\\s*$)", "")).endsWith(PropertiesUtil.PROPERTIES_FILE_SUFFIX) || resourceBundle.contains("/") || CoreUtil.isWindows() && resourceBundle.contains("\\"))) {
                                    resourceBundle = new Path(resourceBundle.replace(".", "/")).toString();
                                }
                                retval.putResourceBundle(resourceBundle);
                            }
                            this.resourceBundleValue = null;
                            this.supportedLocaleValues.clear();
                        }
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName.equals(PropertiesUtil.ELEMENT_RESOURCE_BUNDLE)) {
                            this.isResourceBundleElem = true;
                        }
                        if (qName.equals(PropertiesUtil.ELEMENT_SUPPORTED_LOCALE)) {
                            this.isSupportedLocaleElem = true;
                        }
                    }
                };
                InputStream contents = portletXml.getContents();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                saxParser.parse(contents, handler);
                contents.close();
            }
            catch (SAXException handler) {
            }
            catch (Exception e) {
                LiferayCore.logError("Error resolvingportlet.xml", e);
            }
            tmpResourceNodeInfo = retval;
        }
        return tmpResourceNodeInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNonDefaultEncodingLanguagePropertiesFile(IProject project) {
        if (!CoreUtil.isLiferayProject(project)) {
            project = CoreUtil.getLiferayProject((IResource)project);
        }
        if (project == null) {
            return false;
        }
        try {
            IFile[] languageFiles;
            IFile[] resourceFiles;
            ILiferayProject liferayProject = LiferayCore.create(project);
            IFile[] iFileArray = resourceFiles = PropertiesUtil.getLanguagePropertiesFromPortletXml(liferayProject.getDescriptorFile("portlet.xml"));
            int n = resourceFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (!"UTF-8".equals(file.getCharset())) {
                    return true;
                }
                ++n2;
            }
            IFile[] iFileArray2 = languageFiles = PropertiesUtil.getLanguagePropertiesFromLiferayHookXml(liferayProject.getDescriptorFile("liferay-hook.xml"));
            int n3 = languageFiles.length;
            n = 0;
            while (n < n3) {
                IFile file = iFileArray2[n];
                if (!"UTF-8".equals(file.getCharset())) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (CoreException e) {
            LiferayCore.logError(e);
        }
        return false;
    }

    private static boolean isInPackage(List<String> packages, String className) {
        for (String element : packages) {
            if (element.isEmpty() || !className.startsWith(element) || className.startsWith("com.liferay.portal.kernel.portlet") || className.startsWith("javax.portlet")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLanguagePropertiesFile(IFile targetFile) {
        if (!targetFile.getName().endsWith(PROPERTIES_FILE_SUFFIX)) {
            return false;
        }
        IProject project = CoreUtil.getLiferayProject((IResource)targetFile);
        if (project == null) {
            return false;
        }
        ILiferayProject liferayProject = LiferayCore.create(project);
        IFile portletXml = liferayProject.getDescriptorFile("portlet.xml");
        IFile liferayHookXml = liferayProject.getDescriptorFile("liferay-hook.xml");
        IFolder[] srcFolders = liferayProject.getSourceFolders();
        IPath targetFileLocation = targetFile.getLocation();
        try {
            String[] languagePropertyValues;
            IFolder srcFolder;
            int n;
            IFolder[] iFolderArray;
            int n2;
            if (portletXml != null && portletXml.exists()) {
                IFolder supportedLocaleValues;
                String[] resourceBundleValues;
                String[] stringArray = resourceBundleValues = PropertiesUtil.getResourceNodeInfo(portletXml).getResourceBundlePatterns();
                n2 = resourceBundleValues.length;
                int n3 = 0;
                while (n3 < n2) {
                    String resourceBundleValue = stringArray[n3];
                    iFolderArray = srcFolders;
                    n = srcFolders.length;
                    int n4 = 0;
                    while (n4 < n) {
                        srcFolder = iFolderArray[n4];
                        if (targetFileLocation.makeRelativeTo(srcFolder.getLocation()).toString().replace(PROPERTIES_FILE_SUFFIX, "").matches(resourceBundleValue)) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                srcFolder = supportedLocaleValues = PropertiesUtil.getResourceNodeInfo(portletXml).getSupportedLocalePatterns();
                int n5 = ((String[])srcFolder).length;
                n2 = 0;
                while (n2 < n5) {
                    String suportedLocaleValue = srcFolder[n2];
                    IFolder[] iFolderArray2 = srcFolders;
                    int n6 = srcFolders.length;
                    n = 0;
                    while (n < n6) {
                        IFolder srcFolder2 = iFolderArray2[n];
                        if (targetFileLocation.makeRelativeTo(srcFolder2.getLocation()).toString().replace(PROPERTIES_FILE_SUFFIX, "").matches(suportedLocaleValue)) {
                            return true;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (liferayHookXml == null) return false;
            if (!liferayHookXml.exists()) return false;
            String[] stringArray = languagePropertyValues = PropertiesUtil.getLanguageFileInfo(liferayHookXml).getLanguagePropertyPatterns();
            n2 = languagePropertyValues.length;
            int n7 = 0;
            while (n7 < n2) {
                String languagePropertyValue = stringArray[n7];
                iFolderArray = srcFolders;
                n = srcFolders.length;
                int n8 = 0;
                while (n8 < n) {
                    srcFolder = iFolderArray[n8];
                    if (targetFileLocation.makeRelativeTo(srcFolder.getLocation()).toString().replace(PROPERTIES_FILE_SUFFIX, "").matches(languagePropertyValue)) {
                        return true;
                    }
                    ++n8;
                }
                ++n7;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Properties loadProperties(File f) {
        Properties p = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream stream = new FileInputStream(f);){
                p.load(stream);
                return p;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void saveProperties(Properties props, File resultFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(resultFile);){
                props.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LiferayCore.logError("Could not save file " + resultFile.getName());
        }
    }

    public static IFile[] visitPropertiesFiles(IResource container, String relativePath) {
        try {
            if (relativePath.contains("*")) {
                return new PropertiesVisitor().visitPropertiesFiles(container, relativePath);
            }
            IPath path = container.getFullPath().append(String.valueOf(relativePath) + PROPERTIES_FILE_SUFFIX);
            IFile file = CoreUtil.getWorkspaceRoot().getFile(path);
            if (file != null && file.exists()) {
                return new IFile[]{file};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new IFile[0];
    }

    private static class LanguageFileInfo {
        private final IFile liferayHookXml;
        private final long modificationStamp;
        private final List<String> vals = new ArrayList<String>();

        public LanguageFileInfo(IFile file) {
            this.liferayHookXml = file;
            this.modificationStamp = this.liferayHookXml.getModificationStamp();
        }

        public void addLanguagePropertiesPattern(String languagePropertiesVal) {
            this.vals.add(languagePropertiesVal);
        }

        public String[] getLanguagePropertyPatterns() {
            return this.vals.toArray(new String[0]);
        }

        public IFile getLiferayHookXml() {
            return this.liferayHookXml;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }
    }

    private static class PropertiesVisitor
    implements IResourceProxyVisitor {
        IResource entryResource = null;
        String matchedRelativePath = null;
        final List<IFile> resources = new ArrayList<IFile>();

        private PropertiesVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            IResource resource;
            if (resourceProxy.getType() == 1 && resourceProxy.getName().endsWith(PropertiesUtil.PROPERTIES_FILE_SUFFIX) && (resource = resourceProxy.requestResource()).exists()) {
                String relativePath = resource.getLocation().makeRelativeTo(this.entryResource.getLocation()).toString().replace(PropertiesUtil.PROPERTIES_FILE_SUFFIX, "");
                try {
                    if (relativePath.matches(this.matchedRelativePath)) {
                        this.resources.add((IFile)resource);
                    }
                }
                catch (Exception e) {
                    return true;
                }
            }
            return true;
        }

        public IFile[] visitPropertiesFiles(IResource container, String matchedRelativePath) {
            this.entryResource = container;
            this.matchedRelativePath = matchedRelativePath;
            try {
                container.accept((IResourceProxyVisitor)this, 4);
            }
            catch (CoreException e) {
                LiferayCore.logError(e);
            }
            return this.resources.toArray(new IFile[this.resources.size()]);
        }
    }

    private static class ResourceNodeInfo {
        private final long modificationStamp;
        private final IFile portletXml;
        private final Set<String> resourceBundles = new HashSet<String>();
        private final List<String> resourceBundlesPatterns = new ArrayList<String>();
        private final List<String> supportedLocalePatterns = new ArrayList<String>();

        public ResourceNodeInfo(IFile file) {
            this.portletXml = file;
            this.modificationStamp = this.portletXml.getModificationStamp();
        }

        public void addResourceBundlePattern(String resourceBundlePattern) {
            this.resourceBundlesPatterns.add(resourceBundlePattern);
        }

        public void addSupportedLocalePattern(String supportedLocalePattern) {
            this.supportedLocalePatterns.add(supportedLocalePattern);
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }

        public IFile getPortletXml() {
            return this.portletXml;
        }

        public String[] getResourceBundlePatterns() {
            return this.resourceBundlesPatterns.toArray(new String[0]);
        }

        public Set<String> getResourceBundles() {
            return this.resourceBundles;
        }

        public String[] getSupportedLocalePatterns() {
            return this.supportedLocalePatterns.toArray(new String[0]);
        }

        public void putResourceBundle(String resourceBundle) {
            this.resourceBundles.add(resourceBundle);
        }
    }
}

