/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.action;

import com.liferay.ide.hook.ui.HookUI;
import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class HierarchyJavaTypeBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Hierarchy.Browse.Java.Type";
    private String typeName;
    private String filter;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.typeName = def.getParam("type");
        this.filter = def.getParam("filter");
    }

    public String browse(Presentation context) {
        Element element = this.getModelElement();
        Value property = this.property();
        IProject project = (IProject)element.adapt(IProject.class);
        try {
            int browseDialogStyle;
            block18: {
                int count;
                EnumSet<JavaTypeKind> kinds;
                block17: {
                    JavaTypeConstraintService typeService = (JavaTypeConstraintService)property.service(JavaTypeConstraintService.class);
                    kinds = EnumSet.noneOf(JavaTypeKind.class);
                    kinds.addAll(typeService.kinds());
                    browseDialogStyle = 256;
                    count = kinds.size();
                    if (count != 1) break block17;
                    JavaTypeKind kind = (JavaTypeKind)kinds.iterator().next();
                    switch (kind) {
                        case CLASS: {
                            browseDialogStyle = 2;
                            break block18;
                        }
                        case ABSTRACT_CLASS: {
                            browseDialogStyle = 2;
                            break block18;
                        }
                        case INTERFACE: {
                            browseDialogStyle = 4;
                            break block18;
                        }
                        case ANNOTATION: {
                            browseDialogStyle = 64;
                            break block18;
                        }
                        case ENUM: {
                            browseDialogStyle = 128;
                            break block18;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (count == 2 && (kinds.contains(JavaTypeKind.CLASS) || kinds.contains(JavaTypeKind.ABSTRACT_CLASS))) {
                    if (kinds.contains(JavaTypeKind.INTERFACE)) {
                        browseDialogStyle = 512;
                    } else if (kinds.contains(JavaTypeKind.ENUM)) {
                        browseDialogStyle = 1024;
                    }
                }
            }
            IJavaSearchScope scope = null;
            IType type = JavaCore.create((IProject)project).findType(this.typeName);
            if (type != null) {
                scope = SearchEngine.createHierarchyScope((IType)type);
            }
            SwtPresentation swt = (SwtPresentation)context;
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)swt.shell(), null, (IJavaSearchScope)scope, (int)browseDialogStyle, (boolean)false, (String)this.filter, null);
            String title = property.definition().getLabel(true, CapitalizationType.TITLE_STYLE, false);
            dlg.setTitle(String.valueOf(Msgs.select) + title);
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IType) {
                    return ((IType)results[0]).getFullyQualifiedName();
                }
            }
        }
        catch (JavaModelException e) {
            HookUI.logError((Exception)((Object)e));
        }
        return null;
    }

    private static class Msgs
    extends NLS {
        public static String select;

        static {
            Msgs.initializeMessages((String)HierarchyJavaTypeBrowseActionHandler.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

