/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.server.util.ComponentUtil;
import com.liferay.ide.xml.search.ui.CommonWorkbenchMarkerResolution;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class AddJSRPortletActionMethodMarkerResolution
extends CommonWorkbenchMarkerResolution {
    private final String CODE = "@ProcessAction(name = \"{0}\")\npublic void {0}(ActionRequest actionRequest, ActionResponse actionResponse) '{\n}'";
    private final String[] IMPORTS = new String[]{"javax.portlet.ActionRequest", "javax.portlet.ActionResponse", "javax.portlet.ProcessAction"};
    protected final IType type;

    public AddJSRPortletActionMethodMarkerResolution(IMarker marker, IType type) {
        super(marker);
        this.type = type;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }

    protected String getCode() {
        return "@ProcessAction(name = \"{0}\")\npublic void {0}(ActionRequest actionRequest, ActionResponse actionResponse) '{\n}'";
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return LiferayXMLSearchUI.getDefault().getImageRegistry().get(LiferayXMLSearchUI.PORTLET_IMG);
    }

    protected String[] getImports() {
        return this.IMPORTS;
    }

    public String getLabel() {
        return "add new @ProcessAction method \"" + this.getTextContent(this.marker) + "\" to " + this.type.getElementName();
    }

    protected String getTextContent(IMarker marker) {
        return marker.getAttribute("textContent", "");
    }

    @Override
    protected void resolve(IMarker marker) {
        try {
            NullProgressMonitor npm = new NullProgressMonitor();
            IMethod newMethod = this.type.createMethod(MessageFormat.format(this.getCode(), this.getTextContent(marker)), null, true, (IProgressMonitor)npm);
            String[] stringArray = this.getImports();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String importName = stringArray[n2];
                this.type.getCompilationUnit().createImport(importName, null, (IProgressMonitor)npm);
                ++n2;
            }
            this.type.getCompilationUnit().save((IProgressMonitor)npm, false);
            try {
                JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)newMethod), (IJavaElement)newMethod);
            }
            catch (PartInitException e) {
                LiferayXMLSearchUI.logError("Unable to open java editor on action method", (Exception)((Object)e));
            }
            if (marker.getResource() instanceof IFile) {
                ComponentUtil.validateFile((IFile)((IFile)marker.getResource()), (IProgressMonitor)npm);
            }
        }
        catch (JavaModelException e) {
            LiferayXMLSearchUI.logError("Unable to add JSR process action method", (Exception)((Object)e));
        }
    }
}

