/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LiferayXMLSearchUI
extends AbstractUIPlugin {
    private static LiferayXMLSearchUI plugin;
    private ContextTypeRegistry contextTypeRegistry;
    private TemplateStore templateStore;
    public static String PORTLET_IMG;
    public static final String PLUGIN_ID = "com.liferay.ide.xml.search.ui";
    public static final String SERVICE_XML_TEMPLATES_KEY = "com.liferay.ide.xml.search.ui.service_xml_templates";
    public static final String PREF_KEY_IGNORE_PROJECTS_LIST = "ignore-projects-list";

    static {
        PORTLET_IMG = "portlet";
    }

    public static IStatus createErrorStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return new Status(2, PLUGIN_ID, msg);
    }

    public static LiferayXMLSearchUI getDefault() {
        return plugin;
    }

    public static IEclipsePreferences getInstancePrefs() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("servicexml_tag");
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    public TemplateStore getServiceXmlTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), SERVICE_XML_TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                LiferayXMLSearchUI.logError("Error loading template store.", e);
            }
        }
        return this.templateStore;
    }

    public static void logError(String msg, Exception e) {
        LiferayXMLSearchUI.getDefault().getLog().log(LiferayXMLSearchUI.createErrorStatus(msg, e));
    }

    public static void logError(Throwable t) {
        LiferayXMLSearchUI.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        URL baseIconsURL = this.getBundle().getEntry("icons/");
        ImageDescriptor portletImage = ImageDescriptor.createFromURL((URL)new URL(baseIconsURL, "portlet.png"));
        this.getImageRegistry().put(PORTLET_IMG, portletImage);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

