/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.editor;

import com.liferay.ide.xml.search.ui.editor.MarkerRegion;
import com.liferay.ide.xml.search.ui.editor.TemporaryRegion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

public class CompoundRegion
implements IRegion {
    private int length = Integer.MIN_VALUE;
    private int offset = Integer.MAX_VALUE;
    private List<IRegion> regions = new ArrayList<IRegion>();
    public final int textOffset;
    public final ITextViewer textViewer;

    public CompoundRegion(ITextViewer textViewer, int textOffset) {
        this.textViewer = textViewer;
        this.textOffset = textOffset;
    }

    public void addRegion(IRegion region) {
        Iterator<IRegion> it = this.regions.iterator();
        while (it.hasNext()) {
            IRegion r = it.next();
            if (r.equals(region)) {
                return;
            }
            if (region instanceof TemporaryRegion && r instanceof MarkerRegion && this.compareRegions((MarkerRegion)r, (TemporaryRegion)region)) {
                return;
            }
            if (!(region instanceof MarkerRegion) || !(r instanceof TemporaryRegion) || !this.compareRegions((MarkerRegion)region, (TemporaryRegion)r)) continue;
            it.remove();
        }
        this.regions.add(region);
        int start = Math.min(region.getOffset(), this.offset);
        int end = Math.max(region.getOffset() + region.getLength(), this.offset + this.length);
        this.offset = start;
        this.length = end - start;
    }

    private boolean compareRegions(MarkerRegion m, TemporaryRegion t) {
        try {
            return m.getLength() == t.getLength() && m.getOffset() == t.getOffset() && m.getAnnotation().getText().equals(t.getAnnotation().getText());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<IRegion> getRegions() {
        return this.regions;
    }
}

