/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.resources;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.resource.ResourceBaseURIResolver;

public abstract class AbstractWebResourceURIResolver
extends ResourceBaseURIResolver {
    private final boolean canStartsWithoutSlash;

    public AbstractWebResourceURIResolver(boolean canStartsWithoutSlash) {
        this.canStartsWithoutSlash = canStartsWithoutSlash;
    }

    public boolean accept(Object selectedNode, IResource rootContainer, IResource file, String matching, boolean fullMatch) {
        String extension = file.getFileExtension();
        if (extension == null || !this.getExtensions().contains(extension.toLowerCase())) {
            return false;
        }
        String string = matching = matching == null ? matching : matching.toLowerCase();
        if (fullMatch) {
            if (this.canStartsWithoutSlash) {
                String uri = this.resolve(selectedNode, rootContainer, file).toLowerCase();
                return uri.equals(matching) || uri.equals("/" + matching);
            }
            return this.resolve(selectedNode, rootContainer, file).equals(matching);
        }
        return super.accept(selectedNode, rootContainer, file, matching, fullMatch);
    }

    protected abstract Set<String> getExtensions();

    public String resolve(Object selectedNode, IResource rootContainer, IResource file) {
        return "/" + super.resolve(selectedNode, rootContainer, file);
    }
}

