/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.util.JdtUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiferayHookDescriptorValidator
extends LiferayBaseValidator {
    public static final String MESSAGE_PROPERTIES_NOT_END_WITH_PROPERTIES = Msgs.propertiesNotEndWithProperties;
    public static final String MESSAGE_SERVICE_IMPL_TYPE_INCORRECT = Msgs.serviceImplTypeIncorrect;
    public static final String MESSAGE_SERVICE_TYPE_INVALID = Msgs.serviceTypeInvalid;
    public static final String MESSAGE_SERVICE_TYPE_NOT_INTERFACE = Msgs.serviceTypeNotInterface;

    @Override
    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        int severity = this.getServerity(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
        if (severity != -1 && node.getNodeType() == 3) {
            String validationMsg = null;
            String nodeValue = DOMUtils.getNodeValue((Node)node);
            if (nodeValue != null && nodeValue.length() > 0) {
                if (("portal-properties".equals(node.getParentNode().getNodeName()) || "language-properties".equals(node.getParentNode().getNodeName())) && !nodeValue.endsWith(".properties")) {
                    validationMsg = NLS.bind((String)MESSAGE_PROPERTIES_NOT_END_WITH_PROPERTIES, (Object)nodeValue);
                }
                if (validationMsg != null) {
                    String liferayPluginValidationType = this.getLiferayPluginValidationType(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
                    this.addMessage(node, file, validator, reporter, batchMode, validationMsg, severity, liferayPluginValidationType);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void validateReferenceToJava(IXMLReferenceTo referenceTo, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        if (node.getNodeType() == 3) {
            if ("service-type".equals(node.getParentNode().getNodeName())) {
                ValidationInfo valInfo = this.validateServiceType(node, file);
                if (valInfo != null) {
                    this.addMessage(node, file, validator, reporter, batchMode, valInfo.getValidationMessge(), this.getServerity(valInfo.getValidationType(), file), this.getLiferayPluginValidationType(valInfo.getValidationType(), file));
                }
                return;
            }
            if ("service-impl".equals(node.getParentNode().getNodeName())) {
                ValidationInfo valInfo = this.validateServiceImpl(node, file);
                if (valInfo != null) {
                    this.addMessage(node, file, validator, reporter, batchMode, valInfo.getValidationMessge(), this.getServerity(valInfo.getValidationType(), file), this.getLiferayPluginValidationType(valInfo.getValidationType(), file));
                }
                return;
            }
        }
        super.validateReferenceToJava(referenceTo, node, file, validator, reporter, batchMode);
    }

    private ValidationInfo validateServiceImpl(IDOMNode node, IFile file) {
        String serviceImplContent = DOMUtils.getNodeValue((Node)node);
        IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)serviceImplContent);
        String msg = null;
        if (type == null) {
            msg = this.getMessageText(ValidationPreferences.ValidationType.TYPE_NOT_FOUND, (Node)node);
            return new ValidationInfo(msg, ValidationPreferences.ValidationType.TYPE_NOT_FOUND);
        }
        NodeList siblingNodes = node.getParentNode().getParentNode().getChildNodes();
        IDOMNode serviceTypeNode = null;
        int i = 0;
        while (i < siblingNodes.getLength()) {
            if ("service-type".equals(siblingNodes.item(i).getNodeName())) {
                serviceTypeNode = (IDOMNode)siblingNodes.item(i);
                break;
            }
            ++i;
        }
        try {
            if (serviceTypeNode != null && this.validateServiceType((IDOMNode)serviceTypeNode.getFirstChild(), file) == null) {
                String serviceTypeContent = serviceTypeNode.getFirstChild().getNodeValue().trim();
                String superTypeName = String.valueOf(serviceTypeContent) + "Wrapper";
                IType superType = JdtUtils.getJavaType((IProject)file.getProject(), (String)superTypeName);
                boolean typeCorrect = false;
                if (superType != null && JdtUtils.hierarchyContainsComponent((IType)type, (String)superType.getFullyQualifiedName())) {
                    typeCorrect = true;
                }
                if (!typeCorrect) {
                    msg = NLS.bind((String)MESSAGE_SERVICE_IMPL_TYPE_INCORRECT, (Object)serviceImplContent, (Object)superTypeName);
                    return new ValidationInfo(msg, ValidationPreferences.ValidationType.TYPE_HIERARCHY_INCORRECT);
                }
            }
        }
        catch (Exception e) {
            LiferayXMLSearchUI.logError(e);
        }
        return null;
    }

    private ValidationInfo validateServiceType(IDOMNode node, IFile file) {
        try {
            String serviceTypeContent = DOMUtils.getNodeValue((Node)node);
            IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)serviceTypeContent);
            String msg = null;
            if (type == null) {
                msg = this.getMessageText(ValidationPreferences.ValidationType.TYPE_NOT_FOUND, (Node)node);
                return new ValidationInfo(msg, ValidationPreferences.ValidationType.TYPE_NOT_FOUND);
            }
            if (!type.isInterface()) {
                msg = NLS.bind((String)MESSAGE_SERVICE_TYPE_NOT_INTERFACE, (Object)serviceTypeContent);
                return new ValidationInfo(msg, ValidationPreferences.ValidationType.TYPE_HIERARCHY_INCORRECT);
            }
            if (!serviceTypeContent.matches("com.liferay.*Service")) {
                msg = MESSAGE_SERVICE_TYPE_INVALID;
                return new ValidationInfo(msg, ValidationPreferences.ValidationType.TYPE_HIERARCHY_INCORRECT);
            }
        }
        catch (Exception e) {
            LiferayXMLSearchUI.logError(e);
        }
        return null;
    }

    private static class Msgs
    extends NLS {
        public static String propertiesNotEndWithProperties;
        public static String serviceTypeInvalid;
        public static String serviceTypeNotInterface;
        public static String serviceImplTypeIncorrect;

        static {
            Msgs.initializeMessages((String)LiferayHookDescriptorValidator.class.getName(), Msgs.class);
            Msgs.initializeMessages((String)LiferayHookDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    private class ValidationInfo {
        private String validationMessage;
        private ValidationPreferences.ValidationType validationType;

        public ValidationInfo(String msg, ValidationPreferences.ValidationType type) {
            this.validationMessage = msg;
            this.validationType = type;
        }

        public String getValidationMessge() {
            return this.validationMessage;
        }

        public ValidationPreferences.ValidationType getValidationType() {
            return this.validationType;
        }
    }
}

