/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.w3c.dom.Node;

public class PortletDescriptorValidator
extends LiferayBaseValidator {
    public static final String MESSAGE_RESOURCE_BUNDLE_END_PROPERTIES = Msgs.resourceBundleEndProperties;
    public static final String MESSAGE_RESOURCE_BUNDLE_CONTAIN_PATH_SEPARATOR = Msgs.resourceBundleContainPathSeparator;

    @Override
    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        int severity = this.getServerity(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
        if (severity != -1 && "resource-bundle".equals(node.getParentNode().getNodeName())) {
            String validationMsg = null;
            String nodeValue = DOMUtils.getNodeValue((Node)node);
            if (nodeValue.endsWith(".properties")) {
                validationMsg = NLS.bind((String)MESSAGE_RESOURCE_BUNDLE_END_PROPERTIES, (Object)nodeValue);
            }
            if (validationMsg == null && (nodeValue.contains("/") || CoreUtil.isWindows() && nodeValue.contains("\\"))) {
                validationMsg = NLS.bind((String)MESSAGE_RESOURCE_BUNDLE_CONTAIN_PATH_SEPARATOR, (Object)nodeValue);
            }
            if (validationMsg != null) {
                String liferayPluginValidationType = this.getLiferayPluginValidationType(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
                this.addMessage(node, file, validator, reporter, batchMode, validationMsg, severity, liferayPluginValidationType);
                return false;
            }
        }
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String resourceBundleEndProperties;
        public static String resourceBundleContainPathSeparator;

        static {
            Msgs.initializeMessages((String)PortletDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

