/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.gradle.core.GradleCore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.osgi.framework.Version;

public class GradleTooling {
    private static void extractJar(File depsDir, String jarName) throws IOException {
        File[] files;
        String fullFileName = String.valueOf(jarName) + ".jar";
        File[] fileArray = files = depsDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().startsWith(jarName) && !file.getName().equals(fullFileName) && !file.delete()) {
                GradleCore.logError("Error: delete file " + file.getAbsolutePath() + " fail");
            }
            ++n2;
        }
        String embeddedJarVersion = null;
        File embeddedJarFile = new File(FileLocator.toFileURL((URL)GradleCore.getDefault().getBundle().getEntry("lib/" + fullFileName)).getFile());
        try {
            Throwable throwable = null;
            fileArray = null;
            try (JarFile embededJarFile = new JarFile(embeddedJarFile);){
                embeddedJarVersion = embededJarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File jarFile = new File(depsDir, fullFileName);
        if (jarFile.exists()) {
            boolean shouldDelete = false;
            try {
                Throwable throwable = null;
                Object var9_17 = null;
                try (JarFile jar = new JarFile(jarFile);){
                    String bundleVersion = jar.getManifest().getMainAttributes().getValue("Bundle-Version");
                    if (!CoreUtil.empty((String)bundleVersion)) {
                        Version version = new Version(bundleVersion);
                        Version rightVersion = new Version(embeddedJarVersion);
                        if (version.compareTo(rightVersion) != 0) {
                            shouldDelete = true;
                        }
                    } else {
                        shouldDelete = true;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shouldDelete && !jarFile.delete()) {
                GradleCore.logError("Error: delete file " + jarFile.getAbsolutePath() + " fail");
            }
        }
        if (!jarFile.exists()) {
            FileUtil.copyFile((File)embeddedJarFile, (File)jarFile);
        }
    }

    public static <T> T getModel(Class<T> modelClass, File cacheDir, File projectDir) throws Exception {
        Object retval;
        block9: {
            retval = null;
            GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(projectDir);
            ProjectConnection connection = null;
            try {
                try {
                    connection = connector.connect();
                    ModelBuilder modelBuilder = connection.model(modelClass);
                    File depsDir = new File(cacheDir, "deps");
                    depsDir.mkdirs();
                    String path = depsDir.getAbsolutePath();
                    path = path.replaceAll("\\\\", "/");
                    GradleTooling.extractJar(depsDir, "com.liferay.blade.gradle.model");
                    GradleTooling.extractJar(depsDir, "com.liferay.blade.gradle.plugin");
                    String initScriptTemplate = CoreUtil.readStreamToString((InputStream)GradleTooling.class.getResourceAsStream("init.gradle"));
                    String initScriptContents = initScriptTemplate.replaceFirst("%deps%", path);
                    File scriptFile = new File(cacheDir, "init.gradle");
                    if (!scriptFile.exists()) {
                        scriptFile.createNewFile();
                    }
                    FileUtil.writeFileFromStream((File)scriptFile, (InputStream)new ByteArrayInputStream(initScriptContents.getBytes()));
                    retval = ((ModelBuilder)modelBuilder.withArguments(new String[]{"--init-script", scriptFile.getAbsolutePath()})).get();
                }
                catch (Exception e) {
                    GradleCore.logError("get gradle custom model error", e);
                    if (connection != null) {
                        connection.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.close();
                }
                throw throwable;
            }
            if (connection != null) {
                connection.close();
            }
        }
        return (T)retval;
    }
}

