/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.buildship.core.util.gradle.GradleDistributionValidator;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GradleUtil {
    private static GradleRunConfigurationAttributes getRunConfigurationAttributes(IProject project, String[] tasks) {
        File rootDir = project.getLocation().toFile();
        BuildConfiguration buildConfig = CorePlugin.configurationManager().loadBuildConfiguration(rootDir);
        String projectDirectoryExpression = null;
        Optional gradleProject = CorePlugin.workspaceOperations().findProjectByLocation(rootDir);
        projectDirectoryExpression = gradleProject.isPresent() ? ExpressionUtils.encodeWorkspaceLocation((IProject)((IProject)gradleProject.get())) : rootDir.getAbsolutePath();
        String gradleUserHome = buildConfig.getGradleUserHome() == null ? "" : buildConfig.getGradleUserHome().getAbsolutePath();
        ArrayList<String> taskList = new ArrayList<String>();
        String[] stringArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            String task = stringArray[n2];
            taskList.add(task);
            ++n2;
        }
        return new GradleRunConfigurationAttributes(taskList, projectDirectoryExpression, GradleDistributionSerializer.INSTANCE.serializeToString(buildConfig.getGradleDistribution()), gradleUserHome, null, Collections.emptyList(), Collections.emptyList(), true, true, buildConfig.isOverrideWorkspaceSettings(), buildConfig.isOfflineMode(), buildConfig.isBuildScansEnabled());
    }

    public static IStatus importGradleProject(File dir, IProgressMonitor monitor) throws CoreException {
        Validator projectDirValidator = Validators.and((Validator)Validators.requiredDirectoryValidator((String)"Project root directory"), (Validator)Validators.nonWorkspaceFolderValidator((String)"Project root directory"));
        Validator gradleDistributionValidator = GradleDistributionValidator.gradleDistributionValidator();
        Validator applyWorkingSetsValidator = Validators.nullValidator();
        Validator workingSetsValidator = Validators.nullValidator();
        Validator gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)"Gradle user home");
        ProjectImportConfiguration configuration = new ProjectImportConfiguration(projectDirValidator, gradleDistributionValidator, gradleUserHomeValidator, applyWorkingSetsValidator, workingSetsValidator);
        WorkspaceConfiguration gradleConfig = CorePlugin.configurationManager().loadWorkspaceConfiguration();
        configuration.setProjectDir(dir);
        configuration.setOverwriteWorkspaceSettings(false);
        configuration.setGradleDistribution(GradleDistributionWrapper.from((GradleDistribution)gradleConfig.getGradleDistribution()));
        configuration.setGradleUserHome(gradleConfig.getGradleUserHome());
        configuration.setApplyWorkingSets(Boolean.valueOf(false));
        configuration.setBuildScansEnabled(gradleConfig.isBuildScansEnabled());
        configuration.setOfflineMode(gradleConfig.isOffline());
        BuildConfiguration buildConfig = configuration.toBuildConfig();
        GradleBuild build = CorePlugin.gradleWorkspaceManager().getGradleBuild(buildConfig);
        build.synchronize(NewProjectHandler.IMPORT_AND_MERGE, AsyncHandler.NO_OP);
        GradleUtil.waitImport();
        return Status.OK_STATUS;
    }

    public static boolean isBuildFile(IFile buildFile) {
        return buildFile != null && buildFile.exists() && "build.gradle".equals(buildFile.getName()) && buildFile.getParent() instanceof IProject;
    }

    public static boolean isGradleProject(Object resource) throws CoreException {
        IProject project = null;
        if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else if (resource instanceof IProject) {
            project = (IProject)resource;
        }
        return GradleProjectNature.isPresentOn((IProject)project);
    }

    public static void refreshGradleProject(IProject project) {
        ((GradleBuild)CorePlugin.gradleWorkspaceManager().getGradleBuild(project).get()).synchronize(NewProjectHandler.IMPORT_AND_MERGE);
    }

    public static void runGradleTask(IProject project, String[] tasks, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration launchConfiguration = CorePlugin.gradleLaunchConfigurationManager().getOrCreateRunConfiguration(GradleUtil.getRunConfigurationAttributes(project, tasks));
        ILaunchConfigurationWorkingCopy launchConfigurationWC = launchConfiguration.getWorkingCopy();
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", true);
        launchConfigurationWC.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
        launchConfigurationWC.doSave();
        launchConfigurationWC.launch("run", monitor);
    }

    public static void runGradleTask(IProject project, String task, IProgressMonitor monitor) throws CoreException {
        GradleUtil.runGradleTask(project, new String[]{task}, monitor);
    }

    /*
     * Loose catch block
     */
    public static void waitImport() {
        block12: {
            IWorkspaceRoot root = null;
            try {
                ResourcesPlugin.getWorkspace().checkpoint(true);
                Job.getJobManager().join((Object)"org.eclipse.buildship.core.jobs", (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join((Object)"CheckingGradleConfiguration", (IProgressMonitor)new NullProgressMonitor());
                Thread.sleep(200L);
                root = ResourcesPlugin.getWorkspace().getRoot();
                Job.getJobManager().beginRule((ISchedulingRule)root, null);
            }
            catch (InterruptedException interruptedException) {
                if (root != null) {
                    Job.getJobManager().endRule(root);
                }
                break block12;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (root != null) {
                    Job.getJobManager().endRule(root);
                }
                break block12;
            }
            catch (OperationCanceledException operationCanceledException) {
                if (root != null) {
                    Job.getJobManager().endRule(root);
                }
                break block12;
                {
                    catch (Throwable throwable) {
                        if (root != null) {
                            Job.getJobManager().endRule(root);
                        }
                        throw throwable;
                    }
                }
            }
            if (root == null) break block12;
            Job.getJobManager().endRule((ISchedulingRule)root);
        }
    }
}

