/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ModuleCoreUtil {
    public static void addFacetsIfNeeded(File projectLocation, IProgressMonitor monitor) throws CoreException {
        ArrayList projects = new ArrayList();
        ProjectUtil.collectProjectsFromDirectory(projects, (File)projectLocation);
        for (IProject project : projects) {
            if (!ModuleCoreUtil.hasJsp(project)) continue;
            ModuleCoreUtil.addFacets(project, monitor);
        }
    }

    private static void addFacets(IProject project, IProgressMonitor monitor) throws CoreException {
        ModuleCoreUtil.addNature(project, "org.eclipse.wst.common.modulecore.ModuleCoreNature", monitor);
        ModuleCoreUtil.addNature(project, "org.eclipse.wst.common.project.facet.core.nature", monitor);
        ModuleCoreUtil.addConfigFile(project);
        project.refreshLocal(2, monitor);
    }

    private static void addConfigFile(IProject project) throws CoreException {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project-modules id=\"moduleCoreId\" project-version=\"1.5.0\">\n<wb-module deploy-name=\"PROJECT_NAME\">\n<wb-resource deploy-path=\"/\" source-path=\"/src/main/resources/META-INF/resources\" tag=\"defaultRootSource\"/>\n</wb-module>\n</project-modules>";
        String finalContent = content.replace("PROJECT_NAME", project.getName());
        File compoment = new File(project.getLocation().toFile(), ".settings/org.eclipse.wst.common.component");
        if (!compoment.exists()) {
            FileUtil.writeFile((File)compoment, (byte[])finalContent.getBytes(), (String)project.getName());
        }
    }

    private static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!ModuleCoreUtil.hasNature(project, natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    private static boolean hasJsp(IProject project) {
        final ArrayList list = new ArrayList();
        try {
            IPath projectPath = project.getLocation().append(".project");
            final File projectFile = projectPath.toFile().getCanonicalFile();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    block4: {
                        IPath childProject = resource.getLocation().append(".project");
                        File childFile = childProject.toFile().getCanonicalFile();
                        if (!childFile.exists() || projectFile.equals(childFile)) break block4;
                        return false;
                    }
                    try {
                        String path = resource.getLocation().toPortableString();
                        if (path.contains("resources/META-INF/resources") && resource.getName().endsWith(".jsp")) {
                            list.add(path);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !list.isEmpty();
    }

    private static boolean hasNature(IProject project, String natureId) {
        try {
            return project.hasNature(natureId);
        }
        catch (CoreException e) {
            return false;
        }
    }
}

