/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.action;

import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.action.AbstractWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.editor.WorkflowDefinitionEditor;
import com.liferay.ide.kaleo.ui.editor.WorkflowDefinitionEditorInput;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class EditWorkflowDefinitionAction
extends AbstractWorkflowDefinitionAction {
    public EditWorkflowDefinitionAction(ISelectionProvider sp) {
        super(sp, "Edit Kaleo workflow");
    }

    @Override
    public void perform(Object entry) {
        if (entry instanceof WorkflowDefinitionEntry) {
            IEditorPart[] dirtyEditors;
            final WorkflowDefinitionEntry workflowEntry = (WorkflowDefinitionEntry)entry;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart[] iEditorPartArray = dirtyEditors = page.getDirtyEditors();
            int n = dirtyEditors.length;
            int n2 = 0;
            while (n2 < n) {
                WorkflowDefinitionEditorInput dirtyWorkflowEditorInput;
                boolean opened;
                IEditorPart dirtyEditor = iEditorPartArray[n2];
                IEditorInput editorInput = dirtyEditor.getEditorInput();
                if (editorInput instanceof WorkflowDefinitionEditorInput && (opened = (dirtyWorkflowEditorInput = (WorkflowDefinitionEditorInput)editorInput).getName().contains(workflowEntry.getName()))) {
                    IEditorSite editorSite = dirtyEditor.getEditorSite();
                    boolean saveOld = MessageDialog.openQuestion((Shell)editorSite.getShell(), (String)("Save " + dirtyWorkflowEditorInput.getName()), (String)"Do you want to save contents of this editor?");
                    page.closeEditor(dirtyEditor, saveOld);
                }
                ++n2;
            }
            try {
                WorkflowDefinitionEditorInput editorInput = new WorkflowDefinitionEditorInput(workflowEntry);
                final IEditorPart editor = page.openEditor((IEditorInput)editorInput, "com.liferay.ide.kaleo.ui.editor.workflowDefinition", true, 1);
                editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source.equals(editor) && propId == WorkflowDefinitionEditor.PROP_UPDATE_VERSION) {
                            workflowEntry.getParent().clearCache();
                            ((CommonViewer)EditWorkflowDefinitionAction.this.getSelectionProvider()).refresh(true);
                        }
                    }
                });
            }
            catch (PartInitException e) {
                KaleoUI.logError("Error opening kaleo workflow editor.", (Exception)((Object)e));
            }
        }
    }
}

