/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.diagram;

import com.liferay.ide.kaleo.ui.diagram.ConditionNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.ForkNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.JoinNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.JoinXorNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.NewNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.StateNodeAddActionHandler;
import com.liferay.ide.kaleo.ui.diagram.TaskNodeAddActionHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class KaleoNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.getPart();
        for (DiagramNodeTemplate nodeTemplate : diagramPart.getVisibleNodeTemplates()) {
            NewNodeAddActionHandler addNodeHandler = this.createKaleoNodeActionHandlerForTemplate(nodeTemplate);
            handlers.add((SapphireActionHandler)addNodeHandler);
        }
        return handlers;
    }

    private NewNodeAddActionHandler createKaleoNodeActionHandlerForTemplate(DiagramNodeTemplate nodeTemplate) {
        NewNodeAddActionHandler retval = null;
        if ("state".equals(nodeTemplate.definition().getId().content())) {
            retval = new StateNodeAddActionHandler(nodeTemplate);
        } else if ("task".equals(nodeTemplate.definition().getId().content())) {
            retval = new TaskNodeAddActionHandler(nodeTemplate);
        } else if ("condition".equals(nodeTemplate.definition().getId().content())) {
            retval = new ConditionNodeAddActionHandler(nodeTemplate);
        } else if ("fork".equals(nodeTemplate.definition().getId().content())) {
            retval = new ForkNodeAddActionHandler(nodeTemplate);
        } else if ("join".equals(nodeTemplate.definition().getId().content())) {
            retval = new JoinNodeAddActionHandler(nodeTemplate);
        } else if ("join-xor".equals(nodeTemplate.definition().getId().content())) {
            retval = new JoinXorNodeAddActionHandler(nodeTemplate);
        }
        return retval;
    }
}

