/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ValueProperty;

public class ValuePropertyStorage
extends PlatformObject
implements IStorage {
    private static final String EMPTY_CONTENTS = "";
    private Element modelElement;
    private ValueProperty valueProperty;

    public ValuePropertyStorage(Element modelElement, ValueProperty valueProperty) {
        this.modelElement = modelElement;
        this.valueProperty = valueProperty;
    }

    protected Element element() {
        return this.modelElement;
    }

    public InputStream getContents() throws CoreException {
        Object content = this.modelElement.property(this.valueProperty).content();
        if (content == null) {
            content = EMPTY_CONTENTS;
        }
        return new ByteArrayInputStream(content.toString().getBytes());
    }

    public IPath getFullPath() {
        Object retval = null;
        String localPath = String.valueOf(this.modelElement.type().getSimpleName()) + "." + this.valueProperty.name();
        IFile file = (IFile)this.modelElement.adapt(IFile.class);
        retval = file != null ? file.getFullPath().append(localPath) : new Path(localPath);
        return retval;
    }

    public String getName() {
        return this.valueProperty.name();
    }

    public boolean isReadOnly() {
        return false;
    }
}

