/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.util.IWorkflowValidation;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.editor.WorkflowDefinitionEditorInput;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import com.liferay.ide.kaleo.ui.util.KaleoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.xml.editor.SapphireEditorForXml;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkflowDefinitionEditor
extends SapphireEditorForXml {
    public static final String EDITOR_ID = "com.liferay.ide.kaleo.ui.editor.workflowDefinition";
    public static final int PROP_NODE_WIZARDS_ENABLED = 78595;
    public static int PROP_UPDATE_VERSION = 1028;
    private SapphireDiagramEditor diagramEditor;
    private boolean gridVisible = true;
    private boolean nodeWizardsEnabled = true;
    private PropertyListener propertyListener;
    private boolean showGuides = true;

    public WorkflowDefinitionEditor() {
        super(WorkflowDefinition.TYPE, DefinitionLoader.sdef(WorkflowDefinitionEditor.class).page("DiagramPage"));
        String gridVisibleValue = this.getPersistentProperty(KaleoCore.GRID_VISIBLE_KEY);
        if (!CoreUtil.empty((String)gridVisibleValue)) {
            this.gridVisible = Boolean.parseBoolean(gridVisibleValue);
        }
    }

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    public <A> A adapt(Class<A> adapterType) {
        if (WorkflowDefinitionEditor.class.equals(adapterType)) {
            return adapterType.cast((Object)this);
        }
        if (IServer.class.equals(adapterType) && this.getEditorInput() instanceof WorkflowDefinitionEditorInput) {
            WorkflowDefinitionEditorInput workflowInput = (WorkflowDefinitionEditorInput)this.getEditorInput();
            IServer server = workflowInput.getWorkflowDefinitionEntry().getParent().getParent();
            return adapterType.cast(server);
        }
        return (A)super.adapt(adapterType);
    }

    protected void createDiagramPages() throws PartInitException {
        this.diagramEditor = new SapphireDiagramEditor((SapphireEditor)this, this.getModelElement(), DefinitionLoader.sdef(WorkflowDefinitionEditor.class).page("DiagramPage"));
        this.addEditorPage(0, (IEditorPart)this.diagramEditor);
    }

    protected void createFormPages() throws PartInitException {
        if (this.propertyListener == null) {
            this.propertyListener = new PropertyListener();
        }
        this.getXmlEditor().addPropertyListener((IPropertyListener)this.propertyListener);
    }

    protected void createPages() {
        super.createPages();
        try {
            String id = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
            if ("com.liferay.ide.eclipse.kaleo.ui.perspective.designer".equals(id)) {
                return;
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        String perspectiveSwitch = KaleoUI.getDefault().getPreferenceStore().getString("com.liferay.ide.kaleo.ui.editorPerspectiveSwitch");
        boolean remember = false;
        boolean openPerspective = false;
        if ("prompt".equals(perspectiveSwitch)) {
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getSite().getShell(), (String)"Open Kaleo Designer Perspective?", (String)"This kind of file is associated with the Kaleo Designer perspective.\n\nThis perspective is designed to support Kaleo Workflow development. It places the Properties and Palette views in optimal location relative to the editor area.\n\nDo you want to open this perspective now?", (String)"Remember my decision", (boolean)false, (IPreferenceStore)KaleoUI.getDefault().getPreferenceStore(), (String)"com.liferay.ide.kaleo.ui.editorPerspectiveSwitch");
            remember = toggleDialog.getToggleState();
            boolean bl = openPerspective = toggleDialog.getReturnCode() == 2;
            if (remember) {
                KaleoUI.getPrefStore().setValue("com.liferay.ide.kaleo.ui.editorPerspectiveSwitch", openPerspective ? "always" : "never");
            }
        } else if ("always".equals(perspectiveSwitch)) {
            openPerspective = true;
        }
        if (openPerspective) {
            this.switchToKaleoDesignerPerspective();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.getXmlEditor() != null && this.propertyListener != null) {
            this.getXmlEditor().removePropertyListener((IPropertyListener)this.propertyListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        WorkflowDefinitionEditorInput definitionInput;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof WorkflowDefinitionEditorInput) {
            definitionInput = (WorkflowDefinitionEditorInput)editorInput;
            try {
                IRuntime runtime = definitionInput.getWorkflowDefinitionEntry().getParent().getParent().getRuntime();
                IWorkflowValidation workflowValidation = KaleoCore.getWorkflowValidation((IRuntime)runtime);
                Exception error = workflowValidation.validate((InputStream)new ByteArrayInputStream(this.getXmlEditor().getDocumentProvider().getDocument((Object)definitionInput).get().getBytes()));
                if (error != null && !CoreUtil.isNullOrEmpty((String)error.getMessage())) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Kaleo Workflow Validation", (String)("Unable to save kaleo workflow:\n\n" + error.getMessage()));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.diagramEditor != null) {
            this.diagramEditor.doSave(monitor);
        }
        super.doSave(monitor);
        if (editorInput instanceof WorkflowDefinitionEditorInput) {
            definitionInput = (WorkflowDefinitionEditorInput)editorInput;
            this.saveWorkflowDefinitionEntry(definitionInput);
        }
    }

    public void doSaveAs() {
        this.getXmlEditor().doSaveAs();
    }

    public SapphireDiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    private String getPersistentProperty(QualifiedName key) {
        String retval = null;
        try {
            IFile workspaceFile = (IFile)this.getLocalModelElement().adapt(IFile.class);
            retval = workspaceFile.getPersistentProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public boolean isNodeWizardsEnabled() {
        return this.nodeWizardsEnabled;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isShowGuides() {
        return this.showGuides;
    }

    private void saveWorkflowDefinitionEntry(WorkflowDefinitionEditorInput definitionInput) {
        int draftVersion;
        StructuredTextEditor sourceEditor = this.getXmlEditor();
        final WorkflowDefinitionEntry definition = definitionInput.getWorkflowDefinitionEntry();
        String titleMap = definition.getTitleMap();
        final String titleCurrentValue = definition.getTitleCurrentValue();
        final String definitionContent = sourceEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        final String[] newTitleMap = new String[1];
        if (titleCurrentValue != null && titleMap != null) {
            try {
                String localeCode = Locale.getDefault().toString();
                JSONObject jsonTitleMap = new JSONObject(titleMap);
                Iterator keys = jsonTitleMap.keys();
                while (keys != null && keys.hasNext()) {
                    Object key = keys.next();
                    String value = jsonTitleMap.getString(key.toString());
                    if (value == null || !value.contains(titleCurrentValue)) continue;
                    localeCode = key.toString();
                    break;
                }
                jsonTitleMap.put(localeCode, (Object)titleCurrentValue);
                newTitleMap[0] = jsonTitleMap.toString();
            }
            catch (Exception localeCode) {}
        } else {
            newTitleMap[0] = definition.getTitleMap();
        }
        if (CoreUtil.empty((String)newTitleMap[0])) {
            try {
                newTitleMap[0] = KaleoUtil.createJSONTitleMap(definition.getTitle());
            }
            catch (JSONException localeCode) {
                // empty catch block
            }
        }
        if ((draftVersion = definition.getDraftVersion() + 1) == 0) {
            draftVersion = 1;
        }
        final int newDraftVersion = draftVersion;
        Job saveWorkflowEntry = new Job("Saving kaleo workflow entry."){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus retval = Status.OK_STATUS;
                try {
                    JSONObject updatedDraftDefinition = null;
                    IKaleoConnection kaleoConnection = KaleoCore.getKaleoConnection((IServer)definition.getParent().getParent());
                    try {
                        JSONObject latestDraftDefinition = kaleoConnection.getLatestKaleoDraftDefinition(definition.getName(), definition.getVersion(), definition.getCompanyId());
                        updatedDraftDefinition = latestDraftDefinition != null ? kaleoConnection.updateKaleoDraftDefinition(definition.getName(), newTitleMap[0], definitionContent, latestDraftDefinition.getInt("version"), latestDraftDefinition.getInt("draftVersion"), definition.getCompanyId(), definition.getUserId()) : kaleoConnection.addKaleoDraftDefinition(definition.getName(), newTitleMap[0], definitionContent, definition.getVersion(), newDraftVersion, definition.getUserId(), definition.getGroupId());
                    }
                    catch (Exception e) {
                        updatedDraftDefinition = kaleoConnection.addKaleoDraftDefinition(definition.getName(), newTitleMap[0], definitionContent, definition.getVersion(), newDraftVersion, definition.getUserId(), definition.getGroupId());
                    }
                    final WorkflowDefinitionEntry newNode = WorkflowDefinitionEntry.createFromJSONObject(updatedDraftDefinition);
                    newNode.setParent(definition.getParent());
                    newNode.setCompanyId(definition.getCompanyId());
                    newNode.setContent(definitionContent);
                    newNode.setDraftVersion(newDraftVersion);
                    newNode.setName(definition.getName());
                    newNode.setLocation(definition.getLocation());
                    newNode.setTitleCurrentValue(titleCurrentValue);
                    newNode.setTitleMap(newTitleMap[0]);
                    newNode.setUserId(definition.getUserId());
                    newNode.setVersion(definition.getVersion());
                    newNode.setGroupId(definition.getGroupId());
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowDefinitionEditorInput workflowEditorInput = (WorkflowDefinitionEditorInput)WorkflowDefinitionEditor.this.getEditorInput();
                            workflowEditorInput.setWorkflowDefinitionEntry(newNode);
                            WorkflowDefinitionEditor.this.setPartName(workflowEditorInput.getName());
                            WorkflowDefinitionEditor.this.firePropertyChange(PROP_UPDATE_VERSION);
                        }
                    });
                }
                catch (Exception e) {
                    retval = KaleoUI.createErrorStatus("Could not save kaleo workflow entry.", e);
                }
                return retval;
            }
        };
        saveWorkflowEntry.schedule();
    }

    public void setGridVisible(Boolean gridVisible) {
        this.gridVisible = gridVisible;
        this.setPersistentProperty(KaleoCore.GRID_VISIBLE_KEY, gridVisible.toString());
    }

    public void setNodeWizardsEnabled(boolean enabled) {
        this.nodeWizardsEnabled = enabled;
        this._firePropertyChange(78595);
    }

    private void setPersistentProperty(QualifiedName key, String value) {
        try {
            IFile workspaceFile = (IFile)this.getLocalModelElement().adapt(IFile.class);
            workspaceFile.setPersistentProperty(key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowGuides(boolean showGuides) {
        this.showGuides = showGuides;
    }

    private void switchToKaleoDesignerPerspective() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.liferay.ide.eclipse.kaleo.ui.perspective.designer");
                WorkflowDefinitionEditor.this.getSite().getWorkbenchWindow().getActivePage().setPerspective(perspective);
            }
        });
    }

    private class PropertyListener
    implements IPropertyListener {
        private PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 258: {
                    if (source == WorkflowDefinitionEditor.this.getXmlEditor()) {
                        WorkflowDefinitionEditor.this.setInput(WorkflowDefinitionEditor.this.getXmlEditor().getEditorInput());
                    }
                }
                case 257: {
                    if (source != WorkflowDefinitionEditor.this.getXmlEditor() || WorkflowDefinitionEditor.this.getXmlEditor().getEditorInput() == WorkflowDefinitionEditor.this.getEditorInput()) break;
                    WorkflowDefinitionEditor.this.setInput(WorkflowDefinitionEditor.this.getXmlEditor().getEditorInput());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            WorkflowDefinitionEditor.this._firePropertyChange(1);
                        }
                    };
                    ((Control)WorkflowDefinitionEditor.this.getXmlEditor().getAdapter(Control.class)).getDisplay().asyncExec(runnable);
                    break;
                }
                case 1: {
                    if (source != WorkflowDefinitionEditor.this.getXmlEditor() || WorkflowDefinitionEditor.this.getXmlEditor().getEditorInput() == WorkflowDefinitionEditor.this.getEditorInput()) break;
                    WorkflowDefinitionEditor.this.setInput(WorkflowDefinitionEditor.this.getXmlEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != WorkflowDefinitionEditor.this.getXmlEditor()) break;
                    WorkflowDefinitionEditor.this._firePropertyChange(propId);
                }
            }
        }
    }
}

