/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.services.IServiceLocator;

public class SelectionUtils {
    @Nullable
    public static Repository getRepository(@NonNull IStructuredSelection selection) {
        return SelectionUtils.getRepository(false, selection, null);
    }

    @Nullable
    public static Repository getRepository(@Nullable IEvaluationContext evaluationContext) {
        return SelectionUtils.getRepository(false, SelectionUtils.getSelection(evaluationContext), null);
    }

    @Nullable
    public static Repository getRepositoryOrWarn(@NonNull IStructuredSelection selection, @NonNull Shell shell) {
        return SelectionUtils.getRepository(true, selection, shell);
    }

    @NonNull
    public static IStructuredSelection getSelection(@Nullable IEvaluationContext context) {
        if (context == null) {
            return StructuredSelection.EMPTY;
        }
        Object selection = context.getVariable("activeMenuSelection");
        if (!(selection instanceof ISelection)) {
            selection = context.getVariable("selection");
        }
        if (selection instanceof ITextSelection) {
            return SelectionUtils.getSelectionFromEditorInput(context);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    @NonNull
    public static IStructuredSelection getStructuredSelection(@NonNull ISelection selection) {
        if (selection instanceof ITextSelection) {
            return SelectionUtils.getSelectionFromEditorInput(SelectionUtils.getEvaluationContext());
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    @NonNull
    public static IPath[] getSelectedLocations(@NonNull IStructuredSelection selection) {
        LinkedHashSet<IPath> result = new LinkedHashSet<IPath>();
        for (Object o : selection.toList()) {
            IPath location;
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                location = resource.getLocation();
                if (location == null) continue;
                result.add(location);
                continue;
            }
            location = (IPath)AdapterUtils.adapt(o, IPath.class);
            if (location != null) {
                result.add(location);
                continue;
            }
            for (IResource r : SelectionUtils.extractResourcesFromMapping(o)) {
                IPath l = r.getLocation();
                if (l == null) continue;
                result.add(l);
            }
        }
        return result.toArray(new IPath[result.size()]);
    }

    @NonNull
    public static IResource[] getSelectedResources(@NonNull IStructuredSelection selection) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            result.addAll(SelectionUtils.extractResourcesFromMapping(o));
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static List<IResource> extractResourcesFromMapping(Object o) {
        ResourceTraversal[] traversals;
        ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt((Object)o, ResourceMapping.class);
        if (mapping == null) {
            return Collections.emptyList();
        }
        try {
            traversals = mapping.getTraversals(null, null);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (traversals.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            result.addAll(Arrays.asList(resources));
            ++n2;
        }
        return result;
    }

    @NonNull
    private static Set<Object> getSelectionContents(@NonNull IStructuredSelection selection) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object o : selection.toList()) {
            Repository r = (Repository)AdapterUtils.adapt(o, Repository.class);
            if (r != null) {
                result.add(r);
                continue;
            }
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt(o, ResourceMapping.class);
            if (mapping != null) {
                result.addAll(SelectionUtils.extractResourcesFromMapping(mapping));
                continue;
            }
            IPath location = (IPath)AdapterUtils.adapt(o, IPath.class);
            if (location == null) continue;
            result.add(location);
        }
        return result;
    }

    @Nullable
    private static Repository getRepository(boolean warn, @NonNull IStructuredSelection selection, Shell shell) {
        if (selection.isEmpty()) {
            return null;
        }
        Set<Object> elements = SelectionUtils.getSelectionContents(selection);
        if (GitTraceLocation.SELECTION.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.SELECTION.getLocation(), "selection=" + selection + ", elements=" + elements.toString());
        }
        boolean hadNull = false;
        Repository result = null;
        for (Object location : elements) {
            boolean mismatch;
            Repository repo = null;
            if (location instanceof Repository) {
                repo = (Repository)location;
            } else if (location instanceof IResource) {
                repo = ResourceUtil.getRepository((IResource)((IResource)location));
            } else if (location instanceof IPath) {
                repo = ResourceUtil.getRepository((IPath)((IPath)location));
            }
            if (repo == null) {
                hadNull = true;
            }
            if (result == null) {
                result = repo;
            }
            boolean bl = mismatch = hadNull && result != null;
            if (!mismatch && result == repo) continue;
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
            }
            return null;
        }
        if (result == null) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Repository nextRepo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
                if (nextRepo != null && result != null && result != nextRepo) {
                    if (warn) {
                        MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                    }
                    return null;
                }
                result = nextRepo;
                ++n2;
            }
        }
        if (result == null) {
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_errorFindingRepoTitle, (String)UIText.RepositoryAction_errorFindingRepo);
            }
            return null;
        }
        return result;
    }

    private static IStructuredSelection getSelectionFromEditorInput(IEvaluationContext context) {
        Object nestedEditor;
        Object part = context.getVariable("activePart");
        if (!(part instanceof IEditorPart)) {
            return StructuredSelection.EMPTY;
        }
        Object object = context.getVariable("activeEditorInput");
        Object editor = context.getVariable("activeEditor");
        if (editor instanceof MultiPageEditorPart && (nestedEditor = ((MultiPageEditorPart)editor).getSelectedPage()) instanceof IEditorPart) {
            object = ((IEditorPart)nestedEditor).getEditorInput();
        }
        if (!(object instanceof IEditorInput) && editor instanceof IEditorPart) {
            object = ((IEditorPart)editor).getEditorInput();
        }
        if (object instanceof IEditorInput) {
            FileRevisionEditorInput fileRevisionEditorInput;
            IFileRevision fileRevision;
            IEditorInput editorInput = (IEditorInput)object;
            IResource resource = org.eclipse.ui.ide.ResourceUtil.getResource((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
            if (editorInput instanceof FileRevisionEditorInput && (fileRevision = (fileRevisionEditorInput = (FileRevisionEditorInput)editorInput).getFileRevision()) != null) {
                return new StructuredSelection((Object)fileRevision);
            }
        }
        return StructuredSelection.EMPTY;
    }

    private static IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IHandlerService hsr = CommonUtils.getService((IServiceLocator)activeWorkbenchWindow, IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        return ctx;
    }
}

