/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.views;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.views.AbstractTernOutlineLabelProvider;
import tern.eclipse.jface.images.TernImagesRegistry;
import tern.server.protocol.outline.IJSNode;
import tern.server.protocol.outline.JSNode;
import tern.utils.StringUtils;

public class TernOutlineLabelProvider
extends AbstractTernOutlineLabelProvider {
    @Override
    protected String getUnavailableText() {
        return TernUIMessages.TernOutline_unavailable;
    }

    @Override
    protected Image getUnavailableImage() {
        return ImageResource.getImage("logo");
    }

    @Override
    protected String getComputingText() {
        return TernUIMessages.TernOutline_computing;
    }

    @Override
    protected Image getComputingImage() {
        return ImageResource.getImage("logo");
    }

    @Override
    protected String getText(IJSNode element) {
        return element.getName();
    }

    @Override
    protected Image getImage(IJSNode element) {
        JSNode jsNode = (JSNode)element;
        if (jsNode.isClass()) {
            return TernImagesRegistry.getImage((String)"tern.eclipse.jface.IMG_CLASS");
        }
        if (jsNode.isImport()) {
            return TernImagesRegistry.getImage((String)"tern.eclipse.jface.IMG_IMPORT");
        }
        boolean isFunction = jsNode.isFunction();
        boolean isArray = jsNode.isArray();
        String jsType = jsNode.getType();
        return TernImagesRegistry.getImage((String)jsType, (boolean)isFunction, (boolean)isArray, (boolean)false);
    }

    @Override
    protected StyledString getStyledText(IJSNode element) {
        JSNode node = (JSNode)element;
        StyledString buff = new StyledString(StringUtils.isEmpty((String)node.getName()) ? "" : node.getName());
        String type = node.getType();
        if (!StringUtils.isEmpty((String)type)) {
            buff.append(" : ", StyledString.DECORATIONS_STYLER);
            buff.append(type, StyledString.DECORATIONS_STYLER);
        }
        return buff;
    }
}

