/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.views.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.views.AbstractTernContentOutlinePage;

public abstract class AbstractLexicalSortingAction
extends Action {
    private static final String LEXICAL_SORTING_PREF_NAME = "LexicalSortingAction.isChecked";
    private final AbstractTernContentOutlinePage page;
    private ViewerSorter sorter;

    public AbstractLexicalSortingAction(AbstractTernContentOutlinePage page, String text, String tooltipText, String description, ViewerSorter sorter) {
        super(text, 2);
        this.page = page;
        this.sorter = sorter;
        super.setToolTipText(tooltipText);
        super.setDescription(description);
        super.setImageDescriptor(ImageResource.getImageDescriptor("alphab_sort_co"));
        boolean checked = this.getPreferenceStore().getBoolean(LEXICAL_SORTING_PREF_NAME);
        this.valueChanged(checked, false);
    }

    protected abstract IPreferenceStore getPreferenceStore();

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        final CommonViewer viewer = this.page.getViewer();
        BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (on) {
                    viewer.setSorter(AbstractLexicalSortingAction.this.sorter);
                } else {
                    viewer.setSorter(null);
                }
            }
        });
        if (store) {
            this.getPreferenceStore().setValue(LEXICAL_SORTING_PREF_NAME, on);
        }
    }
}

