/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class LiferayTomcatPlugin
extends Plugin {
    private static LiferayTomcatPlugin plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.server.tomcat.core";
    public static final String PREFERENCES_ADDED_EXT_PLUGIN_TOGGLE_KEY = "ADDED_EXT_PLUGIN_TOGGLE_KEY";
    public static final String PREFERENCES_ADDED_EXT_PLUGIN_WITHOUT_ZIP_TOGGLE_KEY = "ADDED_EXT_PLUGIN_WITHOUT_ZIP_TOGGLE_KEY";
    public static final String PREFERENCES_EE_UPGRADE_MSG_TOGGLE_KEY = "EE_UPGRADE_MSG_TOGGLE_KEY";
    public static final String PREFERENCES_REMOVE_EXT_PLUGIN_TOGGLE_KEY = "REMOVE_EXT_PLUGIN_TOGGLE_KEY";

    public static IStatus createErrorStatus(Exception e) {
        return LiferayTomcatPlugin.createErrorStatus(PLUGIN_ID, e);
    }

    public static IStatus createErrorStatus(String msg) {
        return LiferayTomcatPlugin.createErrorStatus(PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg) {
        return new Status(4, pluginId, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg, Throwable e) {
        return new Status(4, pluginId, msg, e);
    }

    public static IStatus createErrorStatus(String pluginId, Throwable t) {
        return new Status(4, pluginId, t.getMessage(), t);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, message);
    }

    public static IStatus createWarningStatus(String message, String id) {
        return new Status(2, id, message);
    }

    public static IStatus createWarningStatus(String message, String id, Exception e) {
        return new Status(2, id, message, (Throwable)e);
    }

    public static LiferayTomcatPlugin getDefault() {
        return plugin;
    }

    public static IEclipsePreferences getPreferenceStore() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public static void logError(IStatus status) {
        LiferayTomcatPlugin.getDefault().getLog().log(status);
    }

    public static void logError(String msg) {
        LiferayTomcatPlugin.logError(LiferayTomcatPlugin.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        LiferayTomcatPlugin.getDefault().getLog().log(LiferayTomcatPlugin.createErrorStatus(PLUGIN_ID, msg, e));
    }

    public static void logError(Throwable t) {
        LiferayTomcatPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static IStatus warning(String msg) {
        return LiferayTomcatPlugin.createWarningStatus(msg, PLUGIN_ID);
    }

    public static IStatus warning(String msg, Exception e) {
        return LiferayTomcatPlugin.createWarningStatus(msg, PLUGIN_ID, e);
    }

    private void cleanupVersionFiles() {
        File serverInfosTxt;
        File serverInfos;
        File versionTxt;
        File versionProps = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.properties").toFile();
        if (versionProps.exists() && !versionProps.delete()) {
            versionProps.deleteOnExit();
        }
        if ((versionTxt = LiferayTomcatPlugin.getDefault().getStateLocation().append("version.txt").toFile()).exists() && !versionTxt.delete()) {
            versionTxt.deleteOnExit();
        }
        if ((serverInfos = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfos.properties").toFile()).exists() && !serverInfos.delete()) {
            serverInfos.deleteOnExit();
        }
        if ((serverInfosTxt = LiferayTomcatPlugin.getDefault().getStateLocation().append("serverInfo.txt").toFile()).exists() && !serverInfosTxt.delete()) {
            serverInfosTxt.deleteOnExit();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.cleanupVersionFiles();
    }

    public void stop(BundleContext context) throws Exception {
        this.cleanupVersionFiles();
        plugin = null;
        super.stop(context);
    }
}

