/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.maven.core.FacetedMavenProject;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenBundlePluginProject;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenUtil;
import java.util.ArrayList;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class FacetedMavenBundleProject
extends FacetedMavenProject
implements IBundleProject {
    private final MavenBundlePluginProject bundleProject;

    public FacetedMavenBundleProject(IProject project) {
        super(project);
        this.bundleProject = new MavenBundlePluginProject(project);
    }

    @Override
    public <T> T adapt(Class<T> adapterType) {
        if (ILiferayPortal.class.equals(adapterType)) {
            return null;
        }
        return super.adapt(adapterType);
    }

    public boolean filterResource(IPath resourcePath) {
        return this.bundleProject.filterResource(resourcePath);
    }

    public String getBundleShape() {
        return "war";
    }

    public IPath getOutputBundle(boolean cleanBuild, IProgressMonitor monitor) throws CoreException {
        IPath targetFile;
        IPath outputJar = null;
        MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(this.getProject());
        ArrayList<String> goals = new ArrayList<String>();
        if (cleanBuild) {
            goals.add("clean");
        }
        goals.add("package");
        for (String goal : goals) {
            mavenProjectBuilder.runMavenGoal(this.getProject(), goal, monitor);
        }
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + "." + this.getBundleShape();
        IFolder targetFolder = this.getProject().getFolder("target");
        if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
            outputJar = targetFile;
        }
        if (outputJar == null || !outputJar.toFile().exists()) {
            throw new CoreException((IStatus)LiferayMavenCore.createErrorStatus("Unable to get output bundle for project " + this.getProject().getName()));
        }
        return outputJar;
    }

    public IPath getOutputBundlePath() {
        IPath outputJar = null;
        try {
            IPath targetFile;
            IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), null);
            MavenProject mavenProject = projectFacade.getMavenProject(null);
            String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + "." + this.getBundleShape();
            IFolder targetFolder = this.getProject().getFolder("target");
            if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
                outputJar = targetFile;
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError(e);
        }
        return outputJar;
    }

    public String getSymbolicName() throws CoreException {
        return this.bundleProject.getSymbolicName();
    }

    public boolean isFragmentBundle() {
        return false;
    }
}

