/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.project.core.upgrade.ILiferayLegacyProjectUpdater;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LiferayMavenLegacyProjectUpdater
implements ILiferayLegacyProjectUpdater {
    private static String[][] dependenciesConvertMap;
    IStructuredFormatProcessor formatProcessor = new FormatProcessorXML();

    private void addChildNode(Element pluginNode, Document document, String tagName, String value) {
        Element testNode = document.createElement(tagName);
        testNode.appendChild(document.createTextNode(value));
        pluginNode.appendChild(testNode);
    }

    private void addCssBuilderPlugin(Node pluginsNode) {
        Document document = pluginsNode.getOwnerDocument();
        Element cssBuidlerPlugin = document.createElement("plugin");
        this.addChildNode(cssBuidlerPlugin, document, "groupId", "com.liferay");
        this.addChildNode(cssBuidlerPlugin, document, "artifactId", "com.liferay.css.builder");
        this.addChildNode(cssBuidlerPlugin, document, "version", "1.0.21");
        Element executions = document.createElement("executions");
        Element execution = document.createElement("execution");
        executions.appendChild(execution);
        cssBuidlerPlugin.appendChild(executions);
        this.addChildNode(execution, document, "id", "default-build-css");
        this.addChildNode(execution, document, "phase", "generate-sources");
        Element goals = document.createElement("goals");
        execution.appendChild(goals);
        this.addChildNode(goals, document, "goal", "build-css");
        Element configuration = document.createElement("configuration");
        cssBuidlerPlugin.appendChild(configuration);
        this.addChildNode(configuration, document, "docrootDirName", "src/main/webapp");
        pluginsNode.appendChild(cssBuidlerPlugin);
        this.formatNode(cssBuidlerPlugin);
    }

    private void addCssBuilderThemePlugin(Node pluginsNode) {
        Document document = pluginsNode.getOwnerDocument();
        Element cssBuidlerPlugin = document.createElement("plugin");
        this.addChildNode(cssBuidlerPlugin, document, "groupId", "com.liferay");
        this.addChildNode(cssBuidlerPlugin, document, "artifactId", "com.liferay.css.builder");
        this.addChildNode(cssBuidlerPlugin, document, "version", "1.0.23");
        Element executions = document.createElement("executions");
        Element execution = document.createElement("execution");
        executions.appendChild(execution);
        cssBuidlerPlugin.appendChild(executions);
        this.addChildNode(execution, document, "id", "default-build-css");
        this.addChildNode(execution, document, "phase", "compile");
        Element goals = document.createElement("goals");
        execution.appendChild(goals);
        this.addChildNode(goals, document, "goal", "build-css");
        Element configuration = document.createElement("configuration");
        cssBuidlerPlugin.appendChild(configuration);
        this.addChildNode(configuration, document, "docrootDirName", "${com.liferay.portal.tools.theme.builder.outputDir}");
        this.addChildNode(configuration, document, "outputDirName", "/");
        this.addChildNode(configuration, document, "portalCommonPath", "target/deps/com.liferay.frontend.css.common.jar");
        pluginsNode.appendChild(cssBuidlerPlugin);
        this.formatNode(cssBuidlerPlugin);
    }

    private void addDependency(Node dependenciesNode, String groupId, String artifactId, String version, String scope) {
        Document document = dependenciesNode.getOwnerDocument();
        NodeList dependencyList = document.getElementsByTagName("dependency");
        boolean isExist = false;
        if (dependencyList != null && dependencyList.getLength() > 0) {
            int i = 0;
            while (i < dependencyList.getLength()) {
                Element dependency = (Element)dependencyList.item(i);
                String tempGroupId = dependency.getElementsByTagName("groupId").item(0).getTextContent();
                String tempArtifactId = dependency.getElementsByTagName("artifactId").item(0).getTextContent();
                String tempVersion = dependency.getElementsByTagName("version").item(0).getTextContent();
                if (groupId.equals(tempGroupId) && artifactId.equals(tempArtifactId) && version.equals(tempVersion)) {
                    isExist = true;
                }
                ++i;
            }
        }
        if (!isExist) {
            Element dependency = document.createElement("dependency");
            this.addChildNode(dependency, document, "groupId", groupId);
            this.addChildNode(dependency, document, "artifactId", artifactId);
            this.addChildNode(dependency, document, "version", version);
            this.addChildNode(dependency, document, "scope", scope);
            dependenciesNode.appendChild(dependency);
            this.formatNode(dependenciesNode);
        }
    }

    private void addMavenDependencyPlugin(Node pluginsNode) {
        Document document = pluginsNode.getOwnerDocument();
        Element mavenDependencyPlguin = document.createElement("plugin");
        this.addChildNode(mavenDependencyPlguin, document, "artifactId", "maven-dependency-plugin");
        Element executions = document.createElement("executions");
        Element execution = document.createElement("execution");
        executions.appendChild(execution);
        mavenDependencyPlguin.appendChild(executions);
        this.addChildNode(execution, document, "phase", "generate-sources");
        Element goals = document.createElement("goals");
        execution.appendChild(goals);
        this.addChildNode(goals, document, "goal", "copy");
        Element configuration = document.createElement("configuration");
        Element artifactItems = document.createElement("artifactItems");
        Element commonArtifactItem = document.createElement("artifactItem");
        this.addChildNode(commonArtifactItem, document, "groupId", "com.liferay");
        this.addChildNode(commonArtifactItem, document, "artifactId", "com.liferay.frontend.css.common");
        this.addChildNode(commonArtifactItem, document, "version", "2.0.1");
        Element styledArtifactItem = document.createElement("artifactItem");
        this.addChildNode(styledArtifactItem, document, "groupId", "com.liferay");
        this.addChildNode(styledArtifactItem, document, "artifactId", "com.liferay.frontend.theme.styled");
        this.addChildNode(styledArtifactItem, document, "version", "2.0.13");
        Element unstyledArtifactItem = document.createElement("artifactItem");
        this.addChildNode(unstyledArtifactItem, document, "groupId", "com.liferay");
        this.addChildNode(unstyledArtifactItem, document, "artifactId", "com.liferay.frontend.theme.unstyled");
        this.addChildNode(unstyledArtifactItem, document, "version", "2.0.13");
        artifactItems.appendChild(commonArtifactItem);
        artifactItems.appendChild(styledArtifactItem);
        artifactItems.appendChild(unstyledArtifactItem);
        configuration.appendChild(artifactItems);
        this.addChildNode(configuration, document, "outputDirectory", "${project.build.directory}/deps");
        this.addChildNode(configuration, document, "stripVersion", "true");
        mavenDependencyPlguin.appendChild(configuration);
        pluginsNode.appendChild(mavenDependencyPlguin);
        this.formatNode(mavenDependencyPlguin);
    }

    private void addMavenThemePlugins(Node pluginsNode) {
        this.addMavenDependencyPlugin(pluginsNode);
        this.addMavenWarPlugin(pluginsNode);
        this.addCssBuilderThemePlugin(pluginsNode);
        this.addThemeBuilderPlugin(pluginsNode);
    }

    private void addMavenWarPlugin(Node pluginsNode) {
        Document document = pluginsNode.getOwnerDocument();
        Element mavenWarPlguin = document.createElement("plugin");
        this.addChildNode(mavenWarPlguin, document, "artifactId", "maven-war-plugin");
        this.addChildNode(mavenWarPlguin, document, "version", "3.0.0");
        Element configuration = document.createElement("configuration");
        this.addChildNode(configuration, document, "packagingExcludes", "**/*.scss");
        Element webResources = document.createElement("webResources");
        Element resource = document.createElement("resource");
        this.addChildNode(resource, document, "directory", "${com.liferay.portal.tools.theme.builder.outputDir}");
        Element excludes = document.createElement("excludes");
        this.addChildNode(excludes, document, "exclude", "**/*.scss");
        resource.appendChild(excludes);
        webResources.appendChild(resource);
        configuration.appendChild(webResources);
        mavenWarPlguin.appendChild(configuration);
        pluginsNode.appendChild(mavenWarPlguin);
        this.formatNode(mavenWarPlguin);
    }

    private void addProperties(Node propertiesNode) {
        Document document = propertiesNode.getOwnerDocument();
        this.addChildNode((Element)propertiesNode, document, "com.liferay.portal.tools.theme.builder.outputDir", "target/build-theme");
        this.addChildNode((Element)propertiesNode, document, "project.build.sourceEncoding", "UTF-8");
        this.formatNode(propertiesNode);
    }

    private void addServiceBuilderPlugin(Node pluginsNode, String projectName) {
        Document document = pluginsNode.getOwnerDocument();
        Element serviceBuidlerPlugin = document.createElement("plugin");
        this.addChildNode(serviceBuidlerPlugin, document, "groupId", "com.liferay");
        this.addChildNode(serviceBuidlerPlugin, document, "artifactId", "com.liferay.portal.tools.service.builder");
        this.addChildNode(serviceBuidlerPlugin, document, "version", "1.0.142");
        Element configuration = document.createElement("configuration");
        this.addChildNode(configuration, document, "apiDirName", "../" + projectName + "-service/src/main/java");
        this.addChildNode(configuration, document, "autoNamespaceTables", "true");
        this.addChildNode(configuration, document, "buildNumberIncrement", "true");
        this.addChildNode(configuration, document, "hbmFileName", "src/main/resources/META-INF/portlet-hbm.xml");
        this.addChildNode(configuration, document, "implDirName", "src/main/java");
        this.addChildNode(configuration, document, "inputFileName", "src/main/webapp/WEB-INF/service.xml");
        this.addChildNode(configuration, document, "modelHintsFileName", "src/main/resources/META-INF/portlet-model-hints.xml");
        this.addChildNode(configuration, document, "osgiModule", "false");
        this.addChildNode(configuration, document, "pluginName", projectName);
        this.addChildNode(configuration, document, "propsUtil", "com.liferay.util.service.ServiceProps");
        this.addChildNode(configuration, document, "resourcesDirName", "src/main/resources");
        this.addChildNode(configuration, document, "springNamespaces", "beans");
        this.addChildNode(configuration, document, "springFileName", "src/main/resources/META-INF/portlet-spring.xml");
        this.addChildNode(configuration, document, "sqlDirName", "src/main/webapp/WEB-INF/sql");
        this.addChildNode(configuration, document, "sqlFileName", "tables.sql");
        serviceBuidlerPlugin.appendChild(configuration);
        pluginsNode.appendChild(serviceBuidlerPlugin);
        this.formatNode(serviceBuidlerPlugin);
    }

    private void addThemeBuilderPlugin(Node pluginsNode) {
        Document document = pluginsNode.getOwnerDocument();
        Element themeBuidlerPlugin = document.createElement("plugin");
        this.addChildNode(themeBuidlerPlugin, document, "groupId", "com.liferay");
        this.addChildNode(themeBuidlerPlugin, document, "artifactId", "com.liferay.portal.tools.theme.builder");
        this.addChildNode(themeBuidlerPlugin, document, "version", "1.0.1");
        Element executions = document.createElement("executions");
        Element execution = document.createElement("execution");
        executions.appendChild(execution);
        themeBuidlerPlugin.appendChild(executions);
        this.addChildNode(execution, document, "phase", "generate-resources");
        Element goals = document.createElement("goals");
        execution.appendChild(goals);
        this.addChildNode(goals, document, "goal", "build-theme");
        Element configuration = document.createElement("configuration");
        this.addChildNode(configuration, document, "diffsDir", "src/main/webapp/");
        this.addChildNode(configuration, document, "outputDir", "${com.liferay.portal.tools.theme.builder.outputDir}");
        this.addChildNode(configuration, document, "parentDir", "${project.build.directory}/deps/com.liferay.frontend.theme.styled.jar");
        this.addChildNode(configuration, document, "parentName", "_styled");
        this.addChildNode(configuration, document, "unstyledDir", "${project.build.directory}/deps/com.liferay.frontend.theme.unstyled.jar");
        execution.appendChild(configuration);
        pluginsNode.appendChild(themeBuidlerPlugin);
        this.formatNode(themeBuidlerPlugin);
    }

    private void cleanBuildNode(Document document) {
        NodeList buildList = document.getElementsByTagName("build");
        if (buildList == null || buildList.getLength() == 0) {
            return;
        }
        if (buildList.getLength() <= 1) {
            NodeList buildChildrenList;
            Element pluginsNode;
            NodeList pluginList;
            Element buildNode = (Element)buildList.item(0);
            NodeList pluginsList = buildNode.getElementsByTagName("plugins");
            if (pluginsList != null && pluginsList.getLength() == 1 && ((pluginList = (pluginsNode = (Element)pluginsList.item(0)).getElementsByTagName("plugin")) == null || pluginList.getLength() == 0)) {
                buildNode.removeChild(pluginsNode);
            }
            if ((buildChildrenList = buildNode.getChildNodes()) != null && buildChildrenList.getLength() > 0) {
                boolean deleteBuildNode = true;
                int i = 0;
                while (i < buildChildrenList.getLength()) {
                    if (buildChildrenList.item(i).getNodeType() != 3) {
                        deleteBuildNode = false;
                    }
                    ++i;
                }
                if (deleteBuildNode) {
                    buildNode.getParentNode().removeChild(buildNode);
                }
            }
        }
    }

    private void formatNode(Node node) {
        this.formatProcessor.formatNode(node);
    }

    private Node getDependenciesNode(IDOMDocument document) {
        NodeList dependenciesList = document.getElementsByTagName("dependencies");
        if (dependenciesList != null && dependenciesList.getLength() == 1) {
            return dependenciesList.item(0);
        }
        Element dependenciesNode = document.createElement("dependencies");
        document.getElementsByTagName("project").item(0).appendChild(dependenciesNode);
        return dependenciesNode;
    }

    private String[] getFixedArtifactIdAndVersion(String artifactId) {
        if (dependenciesConvertMap == null) {
            dependenciesConvertMap = new String[5][];
            LiferayMavenLegacyProjectUpdater.dependenciesConvertMap[0] = new String[]{"portal-service", "com.liferay.portal.kernel", "2.6.0"};
            LiferayMavenLegacyProjectUpdater.dependenciesConvertMap[1] = new String[]{"util-java", "com.liferay.util.java", "2.0.0"};
            LiferayMavenLegacyProjectUpdater.dependenciesConvertMap[2] = new String[]{"util-bridges", "com.liferay.util.bridges", "2.0.0"};
            LiferayMavenLegacyProjectUpdater.dependenciesConvertMap[3] = new String[]{"util-taglib", "com.liferay.util.taglib", "2.0.0"};
            LiferayMavenLegacyProjectUpdater.dependenciesConvertMap[4] = new String[]{"util-slf4j", "com.liferay.util.slf4j", "1.0.0"};
        }
        String[][] stringArray = dependenciesConvertMap;
        int n = dependenciesConvertMap.length;
        int n2 = 0;
        while (n2 < n) {
            String[] str = stringArray[n2];
            if (artifactId.equals(str[0])) {
                String[] result = new String[]{str[1], str[2]};
                return result;
            }
            ++n2;
        }
        return null;
    }

    private Node getPluginsNode(IDOMDocument document) {
        NodeList buildList = document.getElementsByTagName("build");
        if (buildList != null && buildList.getLength() == 1) {
            IDOMElement buildNode = (IDOMElement)buildList.item(0);
            NodeList pluginsList = buildNode.getElementsByTagName("plugins");
            if (pluginsList == null || pluginsList.getLength() != 1) {
                Element pluginsNode = document.createElement("plugins");
                buildNode.appendChild((Node)pluginsNode);
                return pluginsNode;
            }
            return pluginsList.item(0);
        }
        Element buildNode = document.createElement("build");
        Element pluginsNode = document.createElement("plugins");
        buildNode.appendChild(pluginsNode);
        document.getElementsByTagName("project").item(0).appendChild(buildNode);
        return pluginsNode;
    }

    private Node getPropertiesNode(IDOMDocument document) {
        NodeList nodeList = document.getElementsByTagName("properties");
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element;
                Node node = nodeList.item(0);
                if (node instanceof Element && (element = (Element)node).getParentNode().getNodeName().equals("project")) {
                    return node;
                }
                ++i;
            }
        }
        Element propertiesListNode = document.createElement("properties");
        document.getElementsByTagName("project").item(0).appendChild(propertiesListNode);
        return propertiesListNode;
    }

    private boolean hasDependency(IProject project, String groupId, String artifactId) {
        boolean retVal = false;
        IFile iFile = project.getFile("pom.xml");
        File pomFile = iFile.getLocation().toFile();
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try {
            Throwable throwable = null;
            Object var9_13 = null;
            try (FileReader reader = new FileReader(pomFile.getAbsolutePath());){
                Model model = mavenReader.read((Reader)reader);
                List dependencies = model.getDependencies();
                for (Dependency dependency : dependencies) {
                    if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
                    retVal = true;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        return retVal;
    }

    public boolean isNeedUpgrade(IFile pomFile) {
        String tagName = "artifactId";
        String[] values = new String[]{"liferay-maven-plugin", "portal-service", "util-java", "util-bridges", "util-taglib", "util-slf4j"};
        IDOMModel domModel = null;
        boolean retval = false;
        try {
            try {
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(pomFile);
                IDOMDocument document = domModel.getDocument();
                NodeList elements = document.getElementsByTagName(tagName);
                if (elements != null) {
                    int i = 0;
                    while (i < elements.getLength()) {
                        IDOMElement element = (IDOMElement)elements.item(i);
                        String textContent = element.getTextContent();
                        if (!CoreUtil.empty((String)textContent)) {
                            textContent = textContent.trim();
                            String[] stringArray = values;
                            int n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String str = stringArray[n2];
                                if (textContent.equals(str)) {
                                    retval = true;
                                }
                                ++n2;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
        return retval;
    }

    public boolean isNeedUpgrade(IProject project) {
        IFile pomFile = project.getFile("pom.xml");
        return this.isNeedUpgrade(pomFile);
    }

    private boolean isProtletProject(IProject project) {
        IFile portletFile = project.getFile("src/main/webapp/WEB-INF/portlet.xml");
        IFile liferayPortletFile = project.getFile("src/main/webapp/WEB-INF/liferay-portlet.xml");
        return portletFile.exists() && liferayPortletFile.exists();
    }

    private boolean isServiceBuilderProject(IProject project) {
        IFile serviceFile = project.getFile("src/main/webapp/WEB-INF/service.xml");
        return serviceFile.exists();
    }

    private boolean isServiceBuilderSubProject(IProject project) {
        return project.getName().endsWith("-service") && this.hasDependency(project, "com.liferay.portal", "portal-service");
    }

    private boolean isThemeProject(IProject project) {
        IFile lookAndFeelFile = project.getFile("src/main/webapp/WEB-INF/liferay-look-and-feel.xml");
        return lookAndFeelFile.exists();
    }

    private void removeChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    public void upgradePomFile(IProject project, File outputFile) {
        block34: {
            IFile pomFile = project.getFile("pom.xml");
            IFile tempPomFile = project.getFile(".pom-tmp.xml");
            boolean needUpgrade = this.isNeedUpgrade(pomFile);
            if (outputFile == null && !needUpgrade) {
                return;
            }
            IDOMModel domModel = null;
            try {
                try {
                    Object document2;
                    if (outputFile != null) {
                        pomFile.copy(tempPomFile.getFullPath(), true, null);
                        pomFile = tempPomFile;
                    }
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(pomFile);
                    if (needUpgrade) {
                        document2 = domModel.getDocument();
                        domModel.aboutToChangeModel();
                        NodeList elements = document2.getElementsByTagName("artifactId");
                        if (elements != null) {
                            int i = 0;
                            while (i < elements.getLength()) {
                                IDOMElement element = (IDOMElement)elements.item(i);
                                String textContent = element.getTextContent();
                                if (!CoreUtil.empty((String)textContent)) {
                                    if ((textContent = textContent.trim()).equals("liferay-maven-plugin")) {
                                        IDOMElement liferayMavenPluginNode = (IDOMElement)element.getParentNode();
                                        this.removeChildren((Node)liferayMavenPluginNode);
                                        IDOMElement pluginsNode = (IDOMElement)liferayMavenPluginNode.getParentNode();
                                        pluginsNode.removeChild((Node)liferayMavenPluginNode);
                                    } else if (textContent.equals("portal-service") || textContent.equals("util-java") || textContent.equals("util-bridges") || textContent.equals("util-taglib") || textContent.equals("util-slf4j")) {
                                        IDOMElement dependencyElement = (IDOMElement)element.getParentNode();
                                        String[] fixArtifactIdandVersion = this.getFixedArtifactIdAndVersion(textContent);
                                        this.removeChildren((Node)element);
                                        Text artifactIdTextContent = element.getOwnerDocument().createTextNode(fixArtifactIdandVersion[0]);
                                        element.appendChild((Node)artifactIdTextContent);
                                        NodeList versionList = dependencyElement.getElementsByTagName("version");
                                        if (versionList != null && versionList.getLength() == 1) {
                                            IDOMElement versionElement = (IDOMElement)versionList.item(0);
                                            this.removeChildren((Node)versionElement);
                                            Text versionTextContent = element.getOwnerDocument().createTextNode(fixArtifactIdandVersion[1]);
                                            versionElement.appendChild((Node)versionTextContent);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        if (this.isProtletProject(project)) {
                            this.addCssBuilderPlugin(this.getPluginsNode((IDOMDocument)document2));
                        }
                        if (this.isServiceBuilderProject(project)) {
                            this.addServiceBuilderPlugin(this.getPluginsNode((IDOMDocument)document2), project.getName());
                            this.addDependency(this.getDependenciesNode((IDOMDocument)document2), "biz.aQute.bnd", "biz.aQute.bnd.annotation", "3.2.0", "provided");
                        }
                        if (this.isServiceBuilderSubProject(project)) {
                            this.addDependency(this.getDependenciesNode((IDOMDocument)document2), "biz.aQute.bnd", "biz.aQute.bnd.annotation", "3.2.0", "provided");
                        }
                        if (this.isThemeProject(project)) {
                            this.addProperties(this.getPropertiesNode((IDOMDocument)document2));
                            this.addMavenThemePlugins(this.getPluginsNode((IDOMDocument)document2));
                        }
                        this.cleanBuildNode((Document)document2);
                        domModel.changedModel();
                    }
                    if (tempPomFile.exists()) {
                        tempPomFile.delete(true, null);
                    }
                    if (outputFile != null) {
                        try {
                            document2 = null;
                            Object var8_11 = null;
                            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                                domModel.save((OutputStream)fos);
                                break block34;
                            }
                            catch (Throwable throwable) {
                                if (document2 == null) {
                                    document2 = throwable;
                                } else if (document2 != throwable) {
                                    ((Throwable)document2).addSuppressed(throwable);
                                }
                                throw document2;
                            }
                        }
                        catch (Exception document2) {}
                        break block34;
                    }
                    domModel.save();
                }
                catch (Exception e) {
                    LiferayMavenCore.logError("update pom file error", e);
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
    }
}

