/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenUtil {
    private static final Pattern MAJOR_MINOR_VERSION = Pattern.compile("([0-9]\\.[0-9])\\..*");

    public static Node createNewLiferayProfileNode(Document pomDocument, NewLiferayProfile newLiferayProfile) {
        Element newNode = null;
        String liferayVersion = (String)newLiferayProfile.getLiferayVersion().content();
        try {
            String runtimeName = (String)newLiferayProfile.getRuntimeName().content();
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IRuntime)ServerUtil.getRuntime((String)runtimeName));
            Element root = pomDocument.getDocumentElement();
            Element profiles = NodeUtil.findChildElement((Element)root, (String)"profiles");
            if (profiles == null) {
                newNode = profiles = NodeUtil.appendChildElement((Element)root, (String)"profiles");
            }
            Element newProfile = null;
            if (profiles != null) {
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                newProfile = NodeUtil.appendChildElement((Element)profiles, (String)"profile");
                NodeUtil.appendTextNode((Element)profiles, (String)"\n");
                if (newNode == null) {
                    newNode = newProfile;
                }
            }
            if (newProfile != null) {
                IPath autoDeployDir = liferayRuntime.getAppServerDir().removeLastSegments(1).append("deploy");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendChildElement((Element)newProfile, (String)"id", (String)((String)newLiferayProfile.getId().content()));
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                Element propertiesElement = NodeUtil.appendChildElement((Element)newProfile, (String)"properties");
                NodeUtil.appendTextNode((Element)newProfile, (String)"\n\t");
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.version", (String)liferayVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.maven.plugin.version", (String)liferayVersion);
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.auto.deploy.dir", (String)autoDeployDir.toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.deploy.dir", (String)liferayRuntime.getAppServerDeployDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.lib.global.dir", (String)liferayRuntime.getAppServerLibGlobalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t\t");
                NodeUtil.appendChildElement((Element)propertiesElement, (String)"liferay.app.server.portal.dir", (String)liferayRuntime.getAppServerPortalDir().toOSString());
                NodeUtil.appendTextNode((Element)propertiesElement, (String)"\n\t");
                NodeFormatter formatter = new NodeFormatter();
                formatter.format((Node)newNode);
            }
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Unable to add new liferay profile.", e);
        }
        return newNode;
    }

    public static IStatus executeGoals(IMavenProjectFacade facade, IMavenExecutionContext context, List<String> goals, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        MavenProject mavenProject = facade.getMavenProject(monitor);
        MavenExecutionPlan plan = maven.calculateExecutionPlan(mavenProject, goals, true, monitor);
        List mojos = plan.getMojoExecutions();
        ResolverConfiguration configuration = facade.getResolverConfiguration();
        configuration.setResolveWorkspaceProjects(true);
        for (MojoExecution mojo : mojos) {
            maven.execute(mavenProject, mojo, monitor);
        }
        return Status.OK_STATUS;
    }

    public static IStatus executeMojoGoal(IMavenProjectFacade facade, IMavenExecutionContext context, String goal, IProgressMonitor monitor) throws CoreException {
        List exceptions;
        IStatus retval = null;
        IMaven maven = MavenPlugin.getMaven();
        List<String> goals = Collections.singletonList(goal);
        MavenProject mavenProject = facade.getMavenProject(monitor);
        MavenExecutionPlan plan = maven.calculateExecutionPlan(mavenProject, goals, true, monitor);
        Plugin plugin6x = MavenUtil.getPlugin(facade, "com.liferay.maven.plugins:liferay-maven-plugin", monitor);
        String executionArtifactId = null;
        if (plugin6x != null) {
            executionArtifactId = "liferay-maven-plugin";
        } else {
            Plugin plugin7x = MavenUtil.getPlugin(facade, "com.liferay:com.liferay.portal.tools.service.builder", monitor);
            if (plugin7x != null) {
                executionArtifactId = "com.liferay.portal.tools.service.builder";
            }
        }
        MojoExecution liferayMojoExecution = MavenUtil.getExecution(plan, executionArtifactId);
        if (liferayMojoExecution != null) {
            ResolverConfiguration configuration = facade.getResolverConfiguration();
            configuration.setResolveWorkspaceProjects(true);
            maven.execute(mavenProject, liferayMojoExecution, monitor);
        }
        if ((exceptions = context.getSession().getResult().getExceptions()).size() == 1) {
            retval = LiferayMavenCore.createErrorStatus((Throwable)exceptions.get(0));
        } else if (exceptions.size() > 1) {
            ArrayList<IStatus> statues = new ArrayList<IStatus>();
            for (Throwable t : exceptions) {
                statues.add(LiferayMavenCore.createErrorStatus(t));
            }
            IStatus firstStatus = (IStatus)statues.get(0);
            retval = new MultiStatus("com.liferay.ide.maven.core", 4, statues.toArray(new IStatus[0]), firstStatus.getMessage(), firstStatus.getException());
        }
        return retval == null ? Status.OK_STATUS : retval;
    }

    private static List<MavenProjectInfo> filterProjects(List<MavenProjectInfo> mavenProjects) {
        ArrayList<MavenProjectInfo> result = new ArrayList<MavenProjectInfo>();
        for (MavenProjectInfo info : mavenProjects) {
            if (info == null) continue;
            URI mavenuri = info.getPomFile().getParentFile().toURI();
            if (mavenuri.toString().endsWith("/")) {
                try {
                    mavenuri = new URI(mavenuri.toString().substring(0, mavenuri.toString().length() - 1));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            boolean alreadyExists = false;
            IProject[] iProjectArray = CoreUtil.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.exists() && project.getLocationURI().equals(mavenuri)) {
                    alreadyExists = true;
                    break;
                }
                ++n2;
            }
            if (alreadyExists) continue;
            result.add(info);
        }
        return result;
    }

    private static void findChildMavenProjects(List<MavenProjectInfo> results, Collection<MavenProjectInfo> infos) {
        for (MavenProjectInfo info : infos) {
            results.add(info);
            Collection children = info.getProjects();
            if (children.isEmpty()) continue;
            MavenUtil.findChildMavenProjects(results, children);
        }
    }

    public static MojoExecution getExecution(MavenExecutionPlan plan, String artifactId) {
        if (plan != null) {
            for (MojoExecution execution : plan.getMojoExecutions()) {
                if (!artifactId.equals(execution.getArtifactId())) continue;
                return execution;
            }
        }
        return null;
    }

    public static IFolder getGeneratedThemeResourcesFolder(MavenProject mavenProject, IProject project) {
        IPath m2eLiferayFolder = MavenUtil.getM2eLiferayFolder(mavenProject, project);
        return project.getFolder(m2eLiferayFolder).getFolder("theme-resources");
    }

    public static Xpp3Dom getLiferayMavenPluginConfig(MavenProject mavenProject) {
        Plugin plugin;
        Xpp3Dom retval = null;
        if (mavenProject != null && (plugin = mavenProject.getPlugin("com.liferay.maven.plugins:liferay-maven-plugin")) != null) {
            retval = (Xpp3Dom)plugin.getConfiguration();
        }
        return retval;
    }

    public static String getLiferayMavenPluginConfig(MavenProject mavenProject, String childElement) {
        Xpp3Dom childNode;
        String retval = null;
        Xpp3Dom liferayMavenPluginConfig = MavenUtil.getLiferayMavenPluginConfig(mavenProject);
        if (liferayMavenPluginConfig != null && (childNode = liferayMavenPluginConfig.getChild(childElement)) != null) {
            retval = childNode.getValue();
        }
        return retval;
    }

    public static String getLiferayMavenPluginType(MavenProject mavenProject) {
        return MavenUtil.getLiferayMavenPluginConfig(mavenProject, "pluginType");
    }

    public static String getLocalRepositoryDir() {
        String retval = null;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        String userSettings = mavenConfiguration.getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        }
        MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
        String globalSettings = runtimeManager.getGlobalSettingsFile();
        IMaven maven = MavenPlugin.getMaven();
        try {
            Settings settings = maven.buildSettings(globalSettings, userSettings);
            retval = settings.getLocalRepository();
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get local repository dir.", e);
        }
        if (retval == null) {
            retval = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return retval;
    }

    public static IPath getM2eLiferayFolder(MavenProject mavenProject, IProject project) {
        String buildOutputDir = mavenProject.getBuild().getDirectory();
        String relativeBuildOutputDir = ProjectUtils.getRelativePath((IProject)project, (String)buildOutputDir);
        return new Path(relativeBuildOutputDir).append("m2e-liferay");
    }

    public static String getMajorMinorVersionOnly(String version) {
        String retval = null;
        Matcher matcher = MAJOR_MINOR_VERSION.matcher(version);
        if (matcher.find()) {
            try {
                retval = new Version(matcher.group(1)).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static Plugin getPlugin(IMavenProjectFacade facade, String pluginKey, IProgressMonitor monitor) throws CoreException {
        Plugin retval = null;
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject(monitor);
        if (mavenProject != null) {
            retval = mavenProject.getPlugin(pluginKey);
        }
        if (retval == null) {
            MavenProject parent = mavenProject.getParent();
            if (parent == null) {
                try {
                    if (MavenUtil.loadParentHierarchy(facade, monitor)) {
                        loadedParent = true;
                    }
                }
                catch (CoreException e) {
                    LiferayMavenCore.logError("Error loading parent hierarchy", e);
                }
            }
            while (parent != null && retval == null) {
                retval = parent.getPlugin(pluginKey);
                parent = parent.getParent();
            }
        }
        if (loadedParent) {
            mavenProject.setParent(null);
        }
        return retval;
    }

    public static IMavenProjectFacade getProjectFacade(IProject project) {
        return MavenUtil.getProjectFacade(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IMavenProjectFacade getProjectFacade(IProject project, IProgressMonitor monitor) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IFile pomResource = project.getFile("pom.xml");
        if (pomResource.exists()) {
            return projectManager.create(pomResource, true, monitor);
        }
        return null;
    }

    public static String getVersion(String version) {
        String retval = null;
        DefaultArtifactVersion v = new DefaultArtifactVersion(version);
        retval = String.valueOf(v.getMajorVersion()) + "." + v.getMinorVersion() + "." + v.getIncrementalVersion();
        if ("0.0.0".equals(retval)) {
            retval = v.getQualifier();
        }
        try {
            Version.parseVersion((String)retval);
        }
        catch (Exception e) {
            retval = "0.0.0";
        }
        return retval;
    }

    public static String getWarSourceDirectory(IMavenProjectFacade facade) {
        String retval = null;
        try {
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
            IProject project = facade.getProject();
            retval = new WarPluginConfiguration(mavenProject, project).getWarSourceDirectory();
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get war source directory", e);
        }
        return retval;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDependency(IProject mavenProject, String groupId, String artifactId) {
        mavenReader = new MavenXpp3Reader();
        pomFile = mavenProject.getFile("pom.xml");
        if (pomFile.exists() == false) return false;
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                reader = new FileReader(pomFile.getLocation().toFile());
                try {
                    model = mavenReader.read((Reader)reader);
                    if (model != null) {
                        dependencies = model.getDependencies();
                        var11_13 = dependencies.iterator();
                        while (true) {
                            dependency = (Dependency)var11_13.next();
                            tempgroutId = dependency.getGroupId();
                            tempartifactId = dependency.getArtifactId();
                            if (!groupId.equals(tempgroutId)) {
                            }
                            if (artifactId.equals(tempartifactId)) {
                                return true;
                            }
                            break;
                        }
                    }
                }
                finally {
                    if (var11_13.hasNext()) ** continue;
                }
                return false;
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (Exception var5_7) {
            // empty catch block
        }
        return false;
    }

    public static List<IMavenProjectImportResult> importProject(String location, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenModelManager mavenModelManager = MavenPlugin.getMavenModelManager();
        File root = CoreUtil.getWorkspaceRoot().getLocation().toFile();
        LocalProjectScanner scanner = new LocalProjectScanner(root, location, false, mavenModelManager);
        scanner.run(monitor);
        List projects = scanner.getProjects();
        List<MavenProjectInfo> mavenProjects = new ArrayList<MavenProjectInfo>();
        MavenUtil.findChildMavenProjects(mavenProjects, projects);
        mavenProjects = MavenUtil.filterProjects(mavenProjects);
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration();
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        return projectConfigurationManager.importProjects(mavenProjects, importConfiguration, monitor);
    }

    public static boolean isMavenProject(IProject project) throws CoreException {
        return project != null && project.exists() && project.isAccessible() && (project.hasNature("org.eclipse.m2e.core.maven2Nature") || project.getFile("pom.xml").exists());
    }

    public static boolean isPomFile(IFile pomFile) {
        return pomFile != null && pomFile.exists() && "pom.xml".equals(pomFile.getName()) && pomFile.getParent() instanceof IProject;
    }

    public static boolean loadParentHierarchy(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        boolean loadedParent = false;
        MavenProject mavenProject = facade.getMavenProject(monitor);
        try {
            if (mavenProject.getModel().getParent() == null || mavenProject.getParent() != null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        while (mavenProject != null && mavenProject.getModel().getParent() != null) {
            if (monitor.isCanceled()) break;
            MavenProject parentProject = MavenPlugin.getMaven().resolveParentProject(mavenProject, monitor);
            if (parentProject != null) {
                mavenProject.setParent(parentProject);
                loadedParent = true;
            }
            mavenProject = parentProject;
        }
        return loadedParent;
    }

    public static void setConfigValue(Xpp3Dom configuration, String childName, Object value) {
        Xpp3Dom childNode = configuration.getChild(childName);
        if (childNode == null) {
            childNode = new Xpp3Dom(childName);
            configuration.addChild(childNode);
        }
        childNode.setValue(value == null ? null : value.toString());
    }
}

