/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.ui.wizard;

import com.liferay.ide.server.tomcat.core.LiferayTomcatRuntime;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.ui.util.SWTUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.server.core.IJavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.jst.server.tomcat.ui.internal.TomcatRuntimeComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LiferayTomcatRuntimeComposite
extends TomcatRuntimeComposite
implements ModifyListener {
    protected Text dirField;
    protected boolean ignoreModifyEvent;
    protected Button jreButton;
    protected Combo jreCombo;
    protected Label jreLabel;
    protected Text nameField;

    public static void setFieldValue(Text field, String value) {
        if (field != null && !field.isDisposed()) {
            field.setText(value != null ? value : "");
        }
    }

    public LiferayTomcatRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
        wizard.setTitle(Msgs.liferayTomcatRuntime);
        wizard.setDescription(Msgs.specifyInstallationDirectory);
        wizard.setImageDescriptor(LiferayServerUI.getImageDescriptor((String)"imgWizRuntime"));
    }

    public void modifyText(ModifyEvent e) {
        IPath currentLocation;
        IPath modifiedLocation;
        if (this.ignoreModifyEvent) {
            this.ignoreModifyEvent = false;
            return;
        }
        if (e.getSource().equals(this.dirField)) {
            this.getRuntime().setLocation((IPath)new Path(this.dirField.getText()));
        } else if (e.getSource().equals(this.nameField)) {
            this.getRuntime().setName(this.nameField.getText());
        }
        this.validate();
        IStatus status = this.getRuntime().validate(null);
        if (!status.isOK() && e.getSource().equals(this.dirField) && (modifiedLocation = LiferayTomcatUtil.modifyLocationForBundle((IPath)(currentLocation = this.getRuntime().getLocation()))) != null) {
            this.getRuntime().setLocation(modifiedLocation);
            status = this.getRuntime().validate(null);
            if (status.isOK()) {
                this.ignoreModifyEvent = true;
                this.dirField.setText(modifiedLocation.toOSString());
                this.validate();
            }
        }
        this.enableJREControls(true);
        if (this.getTomcatRuntime().getVMInstall() != null) {
            LiferayTomcatRuntime runtime;
            IVMInstall newVM;
            Path vmLoc = new Path(this.getTomcatRuntime().getVMInstall().getInstallLocation().getPath());
            IPath runtimeLoc = this.getRuntime().getLocation();
            if (!runtimeLoc.isPrefixOf((IPath)vmLoc) && (newVM = (runtime = (LiferayTomcatRuntime)this.getTomcatRuntime()).findPortalBundledJRE(true)) != null) {
                runtime.setVMInstall(newVM);
            }
            this.updateJREs();
        }
    }

    protected Button createButton(String text, int style) {
        Button button = new Button((Composite)this, style);
        button.setText(text);
        GridDataFactory.generate((Control)button, (int)2, (int)1);
        return button;
    }

    protected void createControl() {
        this.setLayout(this.createLayout());
        this.setLayoutData(new GridData(1808));
        this.setBackground(this.getParent().getBackground());
        this.createFields();
        this.enableJREControls(false);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFields() {
        this.nameField = this.createTextField(Msgs.name);
        this.nameField.addModifyListener((ModifyListener)this);
        this.dirField = this.createTextField(Msgs.liferayTomcatDirectory);
        this.dirField.addModifyListener((ModifyListener)this);
        SWTUtil.createButton((Composite)this, (String)Msgs.browse).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(LiferayTomcatRuntimeComposite.this.getShell());
                dd.setMessage(Msgs.selectLiferayTomcatDirectory);
                dd.setFilterPath(LiferayTomcatRuntimeComposite.this.dirField.getText());
                String selectedDir = dd.open();
                if (selectedDir != null) {
                    LiferayTomcatRuntimeComposite.this.dirField.setText(selectedDir);
                }
            }
        });
        this.installLabel = new Label((Composite)this, 131072);
        GridData data = new GridData(768);
        data.horizontalIndent = 10;
        this.installLabel.setLayoutData((Object)data);
        this.install = SWTUtil.createButton((Composite)this, (String)Msgs.install);
        this.install.setVisible(false);
        this.jreLabel = this.createLabel(Msgs.selecteRuntimeJRE);
        this.jreCombo = new Combo((Composite)this, 12);
        this.jreCombo.setLayoutData((Object)new GridData(768));
        this.jreCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int sel = LiferayTomcatRuntimeComposite.this.jreCombo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)LiferayTomcatRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                LiferayTomcatRuntimeComposite.this.getTomcatRuntime().setVMInstall(vmInstall);
                LiferayTomcatRuntimeComposite.this.validate();
            }
        });
        this.jreButton = SWTUtil.createButton((Composite)this, (String)Msgs.installedJREs);
        this.jreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTUtil.showPreferencePage((String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (Shell)LiferayTomcatRuntimeComposite.this.getShell())) {
                    LiferayTomcatRuntimeComposite.this.updateJREs();
                    LiferayTomcatRuntimeComposite.this.validate();
                }
            }
        });
        Link link = this.createLink(Msgs.seeAdditionalConfigurationPage);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LiferayTomcatRuntimeComposite.this.wizard instanceof IWizardPage) {
                    IWizard parentWizard = ((IWizardPage)LiferayTomcatRuntimeComposite.this.wizard).getWizard();
                    parentWizard.getContainer().showPage(((IWizardPage)LiferayTomcatRuntimeComposite.this.wizard).getNextPage());
                }
            }
        });
    }

    protected Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout(2, false);
        return layout;
    }

    protected Link createLink(String linkText) {
        Link link = new Link((Composite)this, 0);
        link.setText(linkText);
        GridDataFactory.generate((Control)link, (int)2, (int)1);
        return link;
    }

    protected void createSpacer() {
        new Label((Composite)this, 0);
    }

    protected Text createTextField(String labelText) {
        this.createLabel(labelText);
        Text text = new Text((Composite)this, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected void enableJREControls(boolean enabled) {
        this.jreLabel.setEnabled(enabled);
        this.jreCombo.setEnabled(enabled);
        this.jreButton.setEnabled(enabled);
    }

    protected IJavaRuntime getJavaRuntime() {
        return this.runtime;
    }

    protected IRuntimeWorkingCopy getRuntime() {
        return this.runtimeWC;
    }

    protected TomcatRuntime getTomcatRuntime() {
        return (TomcatRuntime)this.runtime;
    }

    protected void init() {
        if (this.nameField == null || this.dirField == null || this.getRuntime() == null) {
            return;
        }
        LiferayTomcatRuntimeComposite.setFieldValue(this.nameField, this.getRuntime().getName());
        LiferayTomcatRuntimeComposite.setFieldValue(this.dirField, this.getRuntime().getLocation() != null ? this.getRuntime().getLocation().toOSString() : "");
    }

    protected void updateJREs() {
        IJavaRuntime iJavaRuntime = this.getJavaRuntime();
        IVMInstall currentVM = null;
        currentVM = iJavaRuntime != null && iJavaRuntime.getVMInstall() != null ? iJavaRuntime.getVMInstall() : JavaRuntime.getDefaultVMInstall();
        int currentJREIndex = -1;
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = "<Default Workbench JRE>";
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            if (vmInstall.equals(currentVM)) {
                currentJREIndex = i + 1;
            }
            ++i;
        }
        if (this.jreCombo != null) {
            this.jreCombo.setItems(this.jreNames);
            this.jreCombo.select(currentJREIndex);
        }
    }

    private static class Msgs
    extends NLS {
        public static String browse;
        public static String install;
        public static String installedJREs;
        public static String liferayTomcatDirectory;
        public static String liferayTomcatRuntime;
        public static String name;
        public static String seeAdditionalConfigurationPage;
        public static String selecteRuntimeJRE;
        public static String selectLiferayTomcatDirectory;
        public static String specifyInstallationDirectory;

        static {
            Msgs.initializeMessages((String)LiferayTomcatRuntimeComposite.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

