/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.ui;

import com.liferay.ide.maven.core.model.NewLiferayProfileOp;
import com.liferay.ide.maven.ui.LiferayMavenUI;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.Profile;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.ElementList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public abstract class AbstractProjectMarkerResolution
implements IMarkerResolution2 {
    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        URL url = LiferayMavenUI.getDefault().getBundle().getEntry("/icons/e16/m2e-liferay.png");
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    public void run(IMarker marker) {
        final IProject project = marker.getResource().getProject();
        IProjectConfigurationManager projectManager = MavenPlugin.getProjectConfigurationManager();
        ResolverConfiguration configuration = projectManager.getResolverConfiguration(project);
        List currentProfiles = configuration.getActiveProfileList();
        NewLiferayProfileOp op = (NewLiferayProfileOp)NewLiferayProfileOp.TYPE.instantiate();
        ElementList selectedProfiles = op.getSelectedProfiles();
        for (String currentProfile : currentProfiles) {
            ((Profile)selectedProfiles.insert()).setId(currentProfile);
        }
        int result = this.promptUser(project, (NewLiferayPluginProjectOp)op);
        if (result == 0) {
            configuration.setSelectedProfiles((String)op.getActiveProfilesValue().content());
            boolean changed = projectManager.setResolverConfiguration(project, configuration);
            if (changed) {
                WorkspaceJob job = new WorkspaceJob("Updating project " + project.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        try {
                            MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(project, monitor);
                        }
                        catch (CoreException ex) {
                            return ex.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
                job.schedule();
            }
        }
    }

    protected abstract int promptUser(IProject var1, NewLiferayPluginProjectOp var2);
}

