/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.LayoutTplCore;
import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LayoutTplElementsFactory {
    public static LayoutTplElementsFactory INSTANCE = new LayoutTplElementsFactory();

    public void initPortletColumnFromElement(PortletColumnElement portletColumn, IDOMElement domElement) {
        if (domElement == null) {
            return;
        }
        String existingClassName = domElement.getAttribute("class");
        if (!CoreUtil.isNullOrEmpty((String)existingClassName) && !existingClassName.equals(portletColumn.getClassName().content()) && existingClassName.contains("portlet-column")) {
            portletColumn.setClassName(existingClassName);
        }
        portletColumn.setWeight(LayoutTplUtil.getWeightValue(domElement, -1));
        Object[] portletLayoutDOMElements = LayoutTplUtil.findChildElementsByClassName(domElement, "div", "portlet-layout");
        if (!CoreUtil.isNullOrEmpty((Object[])portletLayoutDOMElements)) {
            Object[] objectArray = portletLayoutDOMElements;
            int n = portletLayoutDOMElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object portletLayoutDOMElement = objectArray[n2];
                PortletLayoutElement portletLayout = (PortletLayoutElement)portletColumn.getPortletLayouts().insert();
                this.initPortletLayoutFromElement(portletLayout, (IDOMElement)portletLayoutDOMElement);
                ++n2;
            }
        }
    }

    public void initPortletLayoutFromElement(PortletLayoutElement portletLayout, IDOMElement domElement) {
        IDOMElement[] portletColumnDOMElements;
        if (domElement == null) {
            return;
        }
        String existingClassName = domElement.getAttribute("class");
        if (!CoreUtil.isNullOrEmpty((String)existingClassName) && existingClassName.contains((CharSequence)portletLayout.getClassName().content())) {
            portletLayout.setClassName(existingClassName);
        }
        IDOMElement[] iDOMElementArray = portletColumnDOMElements = LayoutTplUtil.findChildElementsByClassName(domElement, "div", "portlet-column");
        int n = portletColumnDOMElements.length;
        int n2 = 0;
        while (n2 < n) {
            IDOMElement portletColumnElement = iDOMElementArray[n2];
            PortletColumnElement portletColumn = (PortletColumnElement)portletLayout.getPortletColumns().insert();
            this.initPortletColumnFromElement(portletColumn, portletColumnElement);
            ++n2;
        }
    }

    public LayoutTplElement newLayoutTplFromFile(IFile file, Boolean isBootstrapStyle, Boolean is62) {
        if (file == null || !file.exists()) {
            return null;
        }
        LayoutTplElement layoutTpl = null;
        IDOMModel domModel = null;
        try {
            try {
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(file);
                layoutTpl = this.newLayoutTplFromModel(domModel, isBootstrapStyle, is62);
            }
            catch (Exception e) {
                LayoutTplCore.logError("Unable to read layout template file " + file.getName(), e);
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
        return layoutTpl;
    }

    public LayoutTplElement newLayoutTplFromModel(IDOMModel model, Boolean isBootstrapStyle, Boolean is62) {
        if (model == null) {
            return null;
        }
        LayoutTplElement layoutTpl = null;
        IDOMDocument rootDocument = model.getDocument();
        IDOMElement mainContentElement = LayoutTplUtil.findMainContentElement(rootDocument);
        if (mainContentElement != null) {
            layoutTpl = (LayoutTplElement)LayoutTplElement.TYPE.instantiate();
            layoutTpl.setBootstrapStyle(isBootstrapStyle);
            layoutTpl.setClassName(mainContentElement.getAttribute("class"));
            layoutTpl.setIs62(is62);
            Object[] portletLayoutElements = LayoutTplUtil.findChildElementsByClassName(mainContentElement, "div", "portlet-layout");
            if (!CoreUtil.isNullOrEmpty((Object[])portletLayoutElements)) {
                Object[] objectArray = portletLayoutElements;
                int n = portletLayoutElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object portletLayoutElement = objectArray[n2];
                    PortletLayoutElement portletLayout = (PortletLayoutElement)layoutTpl.getPortletLayouts().insert();
                    this.initPortletLayoutFromElement(portletLayout, (IDOMElement)portletLayoutElement);
                    ++n2;
                }
            }
        }
        return layoutTpl;
    }
}

