/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDispatchAdapter<T> {
    private final Class<T> type;
    private final T source;

    public ProxyDispatchAdapter(Dispatch<? super MethodInvocation> dispatch, Class<T> type, Class<?> ... extraTypes) {
        this.type = type;
        ArrayList types = new ArrayList();
        ClassLoader classLoader = type.getClassLoader();
        types.add(type);
        for (Class<?> extraType : extraTypes) {
            ClassLoader candidate = extraType.getClassLoader();
            if (candidate != classLoader && candidate != null) {
                try {
                    if (candidate.loadClass(type.getName()) != null) {
                        classLoader = candidate;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            types.add(extraType);
        }
        this.source = type.cast(Proxy.newProxyInstance(classLoader, types.toArray(new Class[0]), (InvocationHandler)new DispatchingInvocationHandler(type, dispatch)));
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getSource() {
        return this.source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DispatchingInvocationHandler
    implements InvocationHandler {
        private final Class<?> type;
        private final Dispatch<? super MethodInvocation> dispatch;

        private DispatchingInvocationHandler(Class<?> type, Dispatch<? super MethodInvocation> dispatch) {
            this.type = type;
            this.dispatch = dispatch;
        }

        @Override
        public Object invoke(Object target, Method method, Object[] parameters) throws Throwable {
            if (method.getName().equals("equals")) {
                Object parameter = parameters[0];
                if (parameter == null || !Proxy.isProxyClass(parameter.getClass())) {
                    return false;
                }
                InvocationHandler handler = Proxy.getInvocationHandler(parameter);
                if (!DispatchingInvocationHandler.class.isInstance(handler)) {
                    return false;
                }
                DispatchingInvocationHandler otherHandler = (DispatchingInvocationHandler)handler;
                return otherHandler.type.equals(this.type) && otherHandler.dispatch == this.dispatch;
            }
            if (method.getName().equals("hashCode")) {
                return this.dispatch.hashCode();
            }
            if (method.getName().equals("toString")) {
                return this.type.getSimpleName() + " broadcast";
            }
            this.dispatch.dispatch(new MethodInvocation(method, parameters));
            return null;
        }
    }
}

