/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IStackTraceElement;
import org.eclipse.epp.logging.aeri.core.IStatus;
import org.eclipse.epp.logging.aeri.core.IThrowable;
import org.eclipse.epp.logging.aeri.core.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.ModelSwitch;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;

public class Reports {
    public static Hasher newHasher() {
        return Hashing.murmur3_128().newHasher();
    }

    public static IReport newReport(org.eclipse.core.runtime.IStatus event) {
        Preconditions.checkNotNull((Object)event);
        IReport mReport = IModelFactory.eINSTANCE.createReport();
        mReport.setJavaRuntimeVersion(SystemUtils.JAVA_RUNTIME_VERSION);
        mReport.setEclipseBuildId(System.getProperty("eclipse.buildId", "-"));
        mReport.setEclipseProduct(System.getProperty("eclipse.product", "-"));
        mReport.setOsgiArch(System.getProperty("osgi.arch", "-"));
        mReport.setOsgiWs(System.getProperty("osgi.ws", "-"));
        mReport.setOsgiOs(System.getProperty("org.osgi.framework.os.name", "-"));
        mReport.setOsgiOsVersion(System.getProperty("org.osgi.framework.os.version", "-"));
        mReport.setStatus(Reports.newStatus(event));
        Reports.includeBundles(mReport);
        return mReport;
    }

    private static void includeBundles(IReport report) {
        Preconditions.checkNotNull((Object)report);
        StackTracePackagesCollector v = new StackTracePackagesCollector();
        Reports.visit(report, v);
        HashSet uniqueBundleNames = Sets.newHashSet();
        for (String packageName : v.packages) {
            while (packageName.contains(".")) {
                Bundle guessedBundleForPackageName = Platform.getBundle((String)packageName);
                packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
                if (guessedBundleForPackageName == null || !uniqueBundleNames.add(guessedBundleForPackageName.getSymbolicName())) continue;
                IBundle mBundle = Reports.newBundle(guessedBundleForPackageName);
                report.getPresentBundles().add((Object)mBundle);
            }
        }
    }

    @VisibleForTesting
    public static IStatus newStatus(org.eclipse.core.runtime.IStatus status) {
        boolean needFiltering;
        Throwable exception;
        Preconditions.checkNotNull((Object)status);
        IStatus mStatus = IModelFactory.eINSTANCE.createStatus();
        mStatus.setMessage(Reports.removeSourceFileContents(status.getMessage()));
        mStatus.setSeverity(status.getSeverity());
        mStatus.setCode(status.getCode());
        mStatus.setPluginId(status.getPlugin());
        Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle != null) {
            mStatus.setPluginVersion(bundle.getVersion().toString());
        }
        EList<IStatus> mChildren = mStatus.getChildren();
        Throwable cur = exception = status.getException();
        while (cur != null) {
            if (cur instanceof CoreException) {
                CoreException coreException = (CoreException)cur;
                org.eclipse.core.runtime.IStatus coreExceptionStatus = coreException.getStatus();
                IStatus mCoreExceptionStatus = Reports.newStatus(coreExceptionStatus);
                String detachedMessage = MessageFormat.format("{0} [detached from CoreException of Status ''{1}'' by Error Reporting]", mCoreExceptionStatus.getMessage(), mStatus.getMessage());
                mCoreExceptionStatus.setMessage(detachedMessage);
                mChildren.add(mCoreExceptionStatus);
                break;
            }
            cur = cur.getCause();
        }
        org.eclipse.core.runtime.IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int coreException = 0;
        while (coreException < n) {
            org.eclipse.core.runtime.IStatus child = iStatusArray[coreException];
            mChildren.add(Reports.newStatus(child));
            ++coreException;
        }
        boolean bl = needFiltering = "org.eclipse.ui.monitoring".equals(status.getPlugin()) && (status.getCode() == 0 || status.getCode() == 1);
        if (needFiltering) {
            MultiStatusFilter.filter(mStatus);
        }
        if (exception != null) {
            IThrowable mException = Reports.newThrowable(exception);
            mStatus.setException(mException);
        }
        mStatus.setFingerprint(Reports.newStatusFingerprint(mStatus));
        return mStatus;
    }

    public static String newStatusFingerprint(IStatus mStatus) {
        Preconditions.checkNotNull((Object)mStatus);
        final Hasher hasher = Reports.newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseStatus(IStatus object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                hasher.putInt(object.getSeverity());
                hasher.putInt(object.getCode());
                return null;
            }

            @Override
            public Hasher caseStackTraceElement(IStackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                hasher.putInt(object.getLineNumber());
                return null;
            }

            @Override
            public Hasher caseThrowable(IThrowable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                return null;
            }
        };
        Reports.visit(mStatus, s);
        String hash = hasher.hash().toString();
        return hash;
    }

    private static String removeSourceFileContents(@Nullable String message) {
        if ((message = StringUtils.defaultString((String)message)).contains("----------------------------------- SOURCE BEGIN -------------------------------------")) {
            return "source file contents removed";
        }
        return message;
    }

    public static IThrowable newThrowable(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        IThrowable mThrowable = IModelFactory.eINSTANCE.createThrowable();
        mThrowable.setMessage(throwable.getMessage());
        mThrowable.setClassName(throwable.getClass().getName());
        EList<IStackTraceElement> mStackTrace = mThrowable.getStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            IStackTraceElement mStackTraceElement = Reports.newStackTraceElement(stackTraceElement);
            mStackTrace.add(mStackTraceElement);
            ++n2;
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            if (cause == throwable) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_CYCLIC_EXCEPTION, cause.toString());
                return mThrowable;
            }
            mThrowable.setCause(Reports.newThrowable(cause));
        }
        return mThrowable;
    }

    public static String newThrowableFingerprint(IThrowable throwable, final boolean includeMessages, final boolean includeLineNumbers) {
        Preconditions.checkNotNull((Object)throwable);
        final Hasher hasher = Reports.newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseThrowable(IThrowable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                if (includeMessages) {
                    hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                }
                return null;
            }

            @Override
            public Hasher caseStackTraceElement(IStackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                if (includeLineNumbers) {
                    hasher.putInt(object.getLineNumber());
                }
                return null;
            }
        };
        Reports.visit(throwable, s);
        String hash = hasher.hash().toString();
        return hash;
    }

    public static IStackTraceElement newStackTraceElement(StackTraceElement stackTraceElement) {
        Preconditions.checkNotNull((Object)stackTraceElement);
        IStackTraceElement mStackTraceElement = IModelFactory.eINSTANCE.createStackTraceElement();
        mStackTraceElement.setClassName(StringUtils.defaultString((String)stackTraceElement.getClassName(), (String)"MISSING"));
        mStackTraceElement.setMethodName(StringUtils.defaultString((String)stackTraceElement.getMethodName(), (String)"MISSING"));
        mStackTraceElement.setFileName(stackTraceElement.getFileName());
        mStackTraceElement.setLineNumber(stackTraceElement.getLineNumber());
        mStackTraceElement.setNative(stackTraceElement.isNativeMethod());
        return mStackTraceElement;
    }

    public static IBundle newBundle(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        IBundle mBundle = IModelFactory.eINSTANCE.createBundle();
        mBundle.setName(bundle.getSymbolicName());
        mBundle.setVersion(bundle.getVersion().toString());
        return mBundle;
    }

    public static IReport copy(IReport report) {
        Preconditions.checkNotNull((Object)report);
        return (IReport)EcoreUtil.copy((EObject)report);
    }

    public static IStatus copy(IStatus status) {
        Preconditions.checkNotNull((Object)status);
        return (IStatus)EcoreUtil.copy((EObject)status);
    }

    public static IThrowable copy(IThrowable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        return (IThrowable)EcoreUtil.copy((EObject)throwable);
    }

    public static IStackTraceElement copy(IStackTraceElement stackTraceElement) {
        Preconditions.checkNotNull((Object)stackTraceElement);
        return (IStackTraceElement)EcoreUtil.copy((EObject)stackTraceElement);
    }

    public static IBundle copy(IBundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        return (IBundle)EcoreUtil.copy((EObject)bundle);
    }

    public static String toPrettyString(IReport report) {
        return Reports.toPrettyString(report, new HashMap<String, String>());
    }

    public static String toPrettyString(IReport report, Map<String, String> reportProcessorIdsToReadable) {
        Preconditions.checkNotNull((Object)report);
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor(reportProcessorIdsToReadable);
        Reports.visit(report, prettyPrintVisitor);
        return prettyPrintVisitor.print();
    }

    public static <T, K extends EObject> T visit(K object, ModelSwitch<T> s) {
        TreeIterator allContents;
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(s);
        Object t = s.doSwitch(object);
        if (t != null) {
            return (T)t;
        }
        TreeIterator iterator = allContents = EcoreUtil.getAllContents(object, (boolean)true);
        while (iterator.hasNext()) {
            EObject modelElement = (EObject)iterator.next();
            t = s.doSwitch(modelElement);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    public static void anonymizeMessages(IReport report) {
        Preconditions.checkNotNull((Object)report);
        Reports.visit(report, new ModelSwitch<Void>(){

            @Override
            public Void caseThrowable(IThrowable object) {
                Preconditions.checkNotNull((Object)object);
                if (object.eIsSet((EStructuralFeature)IModelPackage.Literals.THROWABLE__MESSAGE)) {
                    object.setMessage("HIDDEN");
                }
                return null;
            }

            @Override
            public Void caseStatus(IStatus object) {
                Preconditions.checkNotNull((Object)object);
                if (object.eIsSet((EStructuralFeature)IModelPackage.Literals.STATUS__MESSAGE)) {
                    object.setMessage("HIDDEN");
                }
                return null;
            }
        });
    }

    public static void anonymizeStackTraces(IReport report, List<Pattern> regexes) {
        Preconditions.checkNotNull((Object)report);
        Preconditions.checkNotNull(regexes);
        Reports.visit(report, new AnonymizeStackTracesSwitch(regexes));
    }

    public static void anonymizeStackTraces(IThrowable throwable, List<Pattern> regexes) {
        Preconditions.checkNotNull((Object)throwable);
        Preconditions.checkNotNull(regexes);
        Reports.visit(throwable, new AnonymizeStackTracesSwitch(regexes));
    }

    public static void anonymizeStackTraceElements(IStackTraceElement element, List<Pattern> regexes) {
        Reports.visit(element, new AnonymizeStackTracesSwitch(regexes));
    }

    private static final class AnonymizeStackTracesSwitch
    extends ModelSwitch<Void> {
        private final List<Pattern> regexes;

        private AnonymizeStackTracesSwitch(List<Pattern> regexes) {
            Preconditions.checkNotNull(regexes);
            this.regexes = regexes;
        }

        @Override
        public Void caseThrowable(IThrowable object) {
            Preconditions.checkNotNull((Object)object);
            for (Pattern regex : this.regexes) {
                if (!regex.matcher(object.getClassName()).matches()) continue;
                return null;
            }
            object.setClassName("HIDDEN");
            return null;
        }

        @Override
        public Void caseStackTraceElement(IStackTraceElement element) {
            Preconditions.checkNotNull((Object)element);
            String input = String.valueOf(element.getClassName()) + "." + element.getMethodName();
            for (Pattern regex : this.regexes) {
                if (!regex.matcher(input).matches()) continue;
                return null;
            }
            element.setClassName("HIDDEN");
            element.setMethodName("HIDDEN");
            element.setFileName("HIDDEN");
            element.setLineNumber(-1);
            return null;
        }
    }

    private static class MultiStatusFilter {
        private MultiStatusFilter() {
        }

        public static void filter(IStatus status) {
            Preconditions.checkNotNull((Object)status);
            HashSet<IThrowable> throwables = new HashSet<IThrowable>();
            MultiStatusFilter.filter(status, throwables);
        }

        private static void filter(IStatus status, Set<IThrowable> throwables) {
            EList<IStatus> children = status.getChildren();
            int removedCount = 0;
            int i = children.size() - 1;
            while (i >= 0) {
                IStatus childStatus = (IStatus)children.get(i);
                if (MultiStatusFilter.filterChild(childStatus, throwables)) {
                    children.remove(i);
                    ++removedCount;
                } else {
                    MultiStatusFilter.filter(childStatus, throwables);
                }
                --i;
            }
            if (removedCount > 0) {
                status.setMessage(String.format("%s [%d child-status duplicates removed by Error Reporting]", status.getMessage(), removedCount));
            }
        }

        private static boolean filterChild(IStatus status, Set<IThrowable> throwables) {
            IThrowable throwable = status.getException();
            if (throwable.getStackTrace().isEmpty()) {
                return true;
            }
            for (IThrowable t : throwables) {
                if (!MultiStatusFilter.stackTraceMatches(throwable, t)) continue;
                return true;
            }
            throwables.add(throwable);
            return false;
        }

        private static boolean stackTraceMatches(IThrowable throwable, IThrowable t) {
            EList<IStackTraceElement> stackTrace = throwable.getStackTrace();
            EList<IStackTraceElement> stackTrace2 = t.getStackTrace();
            if (stackTrace.size() != stackTrace2.size()) {
                return false;
            }
            int i = 0;
            while (i < stackTrace.size()) {
                IStackTraceElement ste2;
                IStackTraceElement ste = (IStackTraceElement)stackTrace.get(i);
                if (!MultiStatusFilter.classNameAndMethodNameEqual(ste, ste2 = (IStackTraceElement)stackTrace2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean classNameAndMethodNameEqual(IStackTraceElement ste, IStackTraceElement ste2) {
            return ste.getClassName().equals(ste2.getClassName()) && ste.getMethodName().equals(ste2.getMethodName());
        }
    }

    private static class PrettyPrintVisitor
    extends ModelSwitch<Object> {
        private static final int RIGHT_PADDING = 20;
        private StringBuilder reportStringBuilder = new StringBuilder();
        private StringBuilder statusStringBuilder = new StringBuilder();
        private StringBuilder bundlesStringBuilder = new StringBuilder();
        private StringBuilder auxiliaryInformationStringBuilder = new StringBuilder();
        private Map<String, String> directiveToReadable;

        PrettyPrintVisitor(Map<String, String> reportProcessorIdsToReadable) {
            this.directiveToReadable = reportProcessorIdsToReadable;
            this.appendHeadline("BUNDLES", this.bundlesStringBuilder);
        }

        private void appendAttributes(EObject object, StringBuilder builder) {
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                Object value = Objects.firstNonNull((Object)object.eGet((EStructuralFeature)attribute), (Object)"");
                builder.append(StringUtils.rightPad((String)attribute.getName(), (int)20));
                builder.append(value);
                builder.append('\n');
            }
            builder.append("\n");
        }

        private void appendHeadline(String headline, StringBuilder builder) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            String line = String.valueOf(headline.replaceAll(".", "-")) + "\n";
            builder.append(line);
            builder.append(String.valueOf(headline) + "\n");
            builder.append(line);
        }

        @Override
        public Object caseReport(IReport report) {
            Preconditions.checkNotNull((Object)report);
            this.appendHeadline("REPORT", this.reportStringBuilder);
            this.appendAttributes(report, this.reportStringBuilder);
            EMap<String, String> auxiliaryInformation = report.getAuxiliaryInformation();
            this.appendProvidedInformation(auxiliaryInformation, this.auxiliaryInformationStringBuilder);
            return null;
        }

        private void appendProvidedInformation(EMap<String, String> providedInformation, StringBuilder builder) {
            for (Map.Entry entry : providedInformation.entrySet()) {
                String processorId = (String)entry.getKey();
                if (this.directiveToReadable.containsKey(processorId)) {
                    processorId = this.directiveToReadable.get(processorId);
                }
                String information = (String)entry.getValue();
                this.appendHeadline(processorId, this.auxiliaryInformationStringBuilder);
                builder.append(information);
            }
        }

        @Override
        public Object caseStatus(IStatus status) {
            Preconditions.checkNotNull((Object)status);
            this.appendHeadline("STATUS", this.statusStringBuilder);
            this.appendAttributes(status, this.statusStringBuilder);
            IThrowable exception = status.getException();
            if (exception != null) {
                this.statusStringBuilder.append("Exception:");
                this.append(exception, this.statusStringBuilder);
            }
            return null;
        }

        private void append(IThrowable throwable, StringBuilder builder) {
            builder.append(String.format("%s: %s\n", throwable.getClassName(), throwable.getMessage()));
            for (IStackTraceElement element : throwable.getStackTrace()) {
                builder.append(String.format("\t at %s.%s(%s:%s)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
            }
            IThrowable cause = throwable.getCause();
            if (cause != null) {
                this.statusStringBuilder.append("Caused by: ");
                this.append(cause, builder);
            }
        }

        @Override
        public Object caseBundle(IBundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.appendAttributes(bundle, this.bundlesStringBuilder);
            return null;
        }

        public String print() {
            return this.statusStringBuilder + "\n" + this.reportStringBuilder + this.bundlesStringBuilder + "\n" + this.auxiliaryInformationStringBuilder;
        }
    }

    private static final class StackTracePackagesCollector
    extends ModelSwitch<Object> {
        public TreeSet<String> packages = Sets.newTreeSet();

        private StackTracePackagesCollector() {
        }

        @Override
        public Object caseStackTraceElement(IStackTraceElement element) {
            Preconditions.checkNotNull((Object)element);
            String pkg = StringUtils.replace((String)StringUtils.substringBeforeLast((String)element.getClassName(), (String)"."), (String)".internal.", (String)".");
            this.packages.add(pkg);
            return null;
        }
    }
}

