/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.project.core.ProjectCore;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseValidator
extends AbstractValidator {
    public static final String MESSAGE_CLASS_INCORRECT_HIERARCHY = Msgs.typeHierarchyIncorrect;
    public static final String MESSAGE_CLASS_NOT_FOUND = Msgs.classNotFound;
    protected IPreferencesService fPreferencesService = Platform.getPreferencesService();

    protected Map<String, Object>[] checkAllClassElements(Map<String, String> map, IJavaProject javaProject, IFile liferayDescriptorXml, String classExistPreferenceKey, String classHierarchyPreferenceKey, IScopeContext[] preferenceScopes, String preferenceNodeQualifier, List<Map<String, Object>> problems) throws CoreException {
        block10: {
            IStructuredModel liferayDescriptorXmlModel = null;
            IDOMDocument liferayDescriptorXmlDocument = null;
            try {
                try {
                    liferayDescriptorXmlModel = StructuredModelManager.getModelManager().getModelForRead(liferayDescriptorXml);
                    if (liferayDescriptorXmlModel != null && liferayDescriptorXmlModel instanceof IDOMModel && map != null) {
                        liferayDescriptorXmlDocument = ((IDOMModel)liferayDescriptorXmlModel).getDocument();
                        for (String elementName : map.keySet()) {
                            this.checkClassElements(liferayDescriptorXmlDocument, javaProject, elementName, preferenceNodeQualifier, preferenceScopes, classExistPreferenceKey, classHierarchyPreferenceKey, problems, map.get(elementName));
                        }
                    }
                }
                catch (IOException e) {
                    ProjectCore.logError(e);
                    if (liferayDescriptorXmlModel != null) {
                        liferayDescriptorXmlModel.releaseFromRead();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (liferayDescriptorXmlModel != null) {
                    liferayDescriptorXmlModel.releaseFromRead();
                }
                throw throwable;
            }
            if (liferayDescriptorXmlModel != null) {
                liferayDescriptorXmlModel.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    protected Map<String, Object> checkClass(IJavaProject javaProject, Node classSpecifier, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String classExistPreferenceKey, String classHierarchyPreferenceKey, String superTypeNames) {
        block10: {
            String className = NodeUtil.getTextContent((Node)classSpecifier);
            if (className != null && className.length() > 0) {
                IType type = null;
                try {
                    String[] superTypes;
                    type = javaProject.findType(className);
                    if (type == null || !type.exists() || className.startsWith(".")) {
                        String msg = MessageFormat.format(MESSAGE_CLASS_NOT_FOUND, className);
                        return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, classExistPreferenceKey, (IDOMNode)classSpecifier, msg);
                    }
                    if (superTypeNames == null) break block10;
                    boolean typeFound = false;
                    String[] stringArray = superTypes = superTypeNames.split(",");
                    int n = superTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String superType = stringArray[n2];
                        try {
                            ITypeHierarchy supertypeHierarchy;
                            IType checkType = javaProject.findType(superType.trim());
                            if (checkType != null && (supertypeHierarchy = type.newSupertypeHierarchy(null)).contains(checkType)) {
                                typeFound = true;
                                break;
                            }
                        }
                        catch (JavaModelException e) {
                            ProjectCore.logError(e);
                        }
                        ++n2;
                    }
                    if (!typeFound) {
                        String msg = MessageFormat.format(MESSAGE_CLASS_INCORRECT_HIERARCHY, className, superTypeNames);
                        if (superTypeNames.contains(",")) {
                            msg = msg.replaceAll(Msgs.typeLabel, Msgs.possibleTypes);
                        }
                        return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, classHierarchyPreferenceKey, (IDOMNode)classSpecifier, msg);
                    }
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
        }
        return null;
    }

    protected void checkClassElements(IDOMDocument document, IJavaProject javaProject, String classElement, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String classExistPreferenceKey, String classHierarchyPreferenceKey, List<Map<String, Object>> problems, String superTypeNames) {
        NodeList classes = document.getElementsByTagName(classElement);
        int i = 0;
        while (i < classes.getLength()) {
            Node item = classes.item(i);
            Map<String, Object> problem = this.checkClass(javaProject, item, preferenceNodeQualifier, preferenceScopes, classExistPreferenceKey, classHierarchyPreferenceKey, superTypeNames);
            if (problem != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected void checkDocrootElement(IDOMDocument document, String element, IProject project, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String liferayPluginValidationType, String messageKey, List<Map<String, Object>> problems) {
        NodeList elements = document.getElementsByTagName(element);
        int i = 0;
        while (i < elements.getLength()) {
            Node item = elements.item(i);
            Map<String, Object> problem = this.checkDocrootResource(item, project, preferenceNodeQualifier, preferenceScopes, liferayPluginValidationType, messageKey);
            if (problem != null) {
                problems.add(problem);
            }
            ++i;
        }
    }

    protected Map<String, Object> checkDocrootResource(Node resourceSpecifier, IProject project, String preferenceNodeQualifier, IScopeContext[] preferenceScopes, String preferenceKey, String errorMessage) {
        IResource resource;
        IWebProject webproject;
        String resourceValue = NodeUtil.getTextContent((Node)resourceSpecifier);
        if (!(resourceValue == null || resourceValue.length() <= 0 || (webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project)) == null || (resource = webproject.findDocrootResource((IPath)new Path(resourceValue))) != null && resource.exists())) {
            String msg = MessageFormat.format(errorMessage, resourceValue);
            return this.createMarkerValues(preferenceNodeQualifier, preferenceScopes, preferenceKey, (IDOMNode)resourceSpecifier, msg);
        }
        return null;
    }

    protected Map<String, Object> createMarkerValues(String qualifier, IScopeContext[] preferenceScopes, String preferenceKey, IDOMNode domNode, String message) {
        Integer severity = this.getMessageSeverity(qualifier, preferenceScopes, preferenceKey);
        if (severity == null) {
            return null;
        }
        HashMap<String, Object> markerValues = new HashMap<String, Object>();
        this.setMarkerValues(markerValues, severity, domNode, message);
        return markerValues;
    }

    protected Map<String, String> getAllClasseElements(String liferayDescriptorClassElementsProperties) {
        HashMap<String, String> map;
        block13: {
            map = new HashMap<String, String>();
            Properties p = new Properties();
            InputStream resource = null;
            try {
                try {
                    resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(liferayDescriptorClassElementsProperties);
                    p.load(resource);
                    for (Object key : p.keySet()) {
                        String elementName = key.toString();
                        String typeNames = p.get(key).toString();
                        map.put(elementName, typeNames);
                    }
                }
                catch (IOException e) {
                    ProjectCore.logError(e);
                    if (resource == null) break block13;
                    try {
                        resource.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (resource != null) {
                    try {
                        resource.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return map;
    }

    protected IPath[] getSourceEntries(IJavaProject javaProject) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        try {
            IClasspathEntry[] classpathEntries;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    paths.add(entry.getPath());
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ProjectCore.logError("Error resolving classpath.", (Exception)((Object)e));
        }
        return paths.toArray(new IPath[0]);
    }

    protected Integer getMessageSeverity(String qualifier, IScopeContext[] preferenceScopes, String key) {
        int sev = this.fPreferencesService.getInt(qualifier, key, 2, preferenceScopes);
        switch (sev) {
            case 1: {
                return new Integer(2);
            }
            case 2: {
                return new Integer(1);
            }
            case 3: {
                return new Integer(0);
            }
            case -1: {
                return null;
            }
        }
        return new Integer(1);
    }

    protected void setMarkerValues(Map<String, Object> markerValues, Object severity, IDOMNode domNode, String message) {
        markerValues.put("severity", severity);
        int start = domNode.getStartOffset();
        if (domNode.getStartStructuredDocumentRegion() != null && domNode.getEndStructuredDocumentRegion() != null) {
            start = domNode.getStartStructuredDocumentRegion().getEndOffset();
        }
        int end = domNode.getEndOffset();
        if (domNode.getStartStructuredDocumentRegion() != null && domNode.getEndStructuredDocumentRegion() != null) {
            end = domNode.getEndStructuredDocumentRegion().getStartOffset();
        }
        int line = domNode.getStructuredDocument().getLineOfOffset(start);
        markerValues.put("charStart", new Integer(start));
        markerValues.put("charEnd", new Integer(end));
        markerValues.put("lineNumber", new Integer(line + 1));
        markerValues.put("message", message);
    }

    public boolean shouldClearMarkers(ValidationEvent event) {
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String classNotFound;
        public static String possibleTypes;
        public static String typeLabel;
        public static String typeHierarchyIncorrect;

        static {
            Msgs.initializeMessages((String)BaseValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

