/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.AbstractRemoteServerPublisher;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class SDKProjectRemoteServerPublisher
extends AbstractRemoteServerPublisher {
    private SDK sdk;

    public SDKProjectRemoteServerPublisher(IProject project, SDK sdk) {
        super(project);
        this.sdk = sdk;
    }

    public IPath publishModuleFull(IProgressMonitor monitor) throws CoreException {
        IPath deployPath = LiferayServerCore.getTempLocation((String)"direct-deploy", (String)"");
        File warFile = deployPath.append(String.valueOf(this.getProject().getName()) + ".war").toFile();
        warFile.getParentFile().mkdirs();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("auto.deploy.unpack.war", "false");
        ILiferayRuntime runtime = ServerUtil.getLiferayRuntime((IProject)this.getProject());
        String appServerDeployDirProp = ServerUtil.getAppServerPropertyKey((String)"app.server{0}deploy.dir", (ILiferayRuntime)runtime);
        properties.put(appServerDeployDirProp, deployPath.toOSString());
        properties.put("plugin.file.default", warFile.getAbsolutePath());
        properties.put("plugin.file", warFile.getAbsolutePath());
        String fileTimeStamp = String.valueOf(System.currentTimeMillis());
        properties.put("lp.version", fileTimeStamp);
        properties.put("lp.version.file.suffix", ".0");
        IStatus status = this.sdk.validate();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        IStatus directDeployStatus = this.sdk.war(this.getProject(), properties, true, new String[]{"-Duser.timezone=GMT"}, monitor);
        if (!directDeployStatus.isOK() || !warFile.exists()) {
            String pluginVersion = "1";
            Path pluginPropertiesPath = new Path("WEB-INF/liferay-plugin-package.properties");
            IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.getProject());
            if (webproject != null) {
                IResource propsRes = webproject.findDocrootResource((IPath)pluginPropertiesPath);
                if (propsRes instanceof IFile && propsRes.exists()) {
                    try {
                        PropertiesConfiguration pluginPackageProperties = new PropertiesConfiguration();
                        InputStream is = ((IFile)propsRes).getContents();
                        pluginPackageProperties.load(is);
                        pluginVersion = pluginPackageProperties.getString("module-incremental-version");
                        is.close();
                    }
                    catch (Exception e) {
                        LiferayCore.logError((String)"error reading module-incremtnal-version. ", (Throwable)e);
                    }
                }
                if (!(warFile = this.sdk.getLocation().append("dist").append(String.valueOf(this.getProject().getName()) + "-" + fileTimeStamp + "." + pluginVersion + ".0" + ".war").toFile()).exists()) {
                    throw new CoreException(directDeployStatus);
                }
            }
        }
        return new Path(warFile.getAbsolutePath());
    }
}

