/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model;

import com.liferay.ide.core.util.MultiStatusBuilder;
import com.liferay.ide.project.core.model.NamedItem;
import com.liferay.ide.project.core.model.ProjectNamedItem;
import com.liferay.ide.project.core.model.SDKProjectsImportOp;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class SDKImportProjectsOpMethods {
    public static final Status execute(final SDKProjectsImportOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Importing Liferay plugin projects...", 100);
        Status retval = Status.createOkStatus();
        Path projectLocation = (Path)op.getSdkLocation().content();
        if (projectLocation == null || projectLocation.isEmpty()) {
            return Status.createErrorStatus((String)"Project cannot be empty");
        }
        WorkspaceJob job = new WorkspaceJob("Importing Liferay projects..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MultiStatusBuilder statusBuilder = new MultiStatusBuilder("com.liferay.ide.project.core");
                ElementList<ProjectNamedItem> projectItems = op.getSelectedProjects();
                for (NamedItem projectNamedItem : projectItems) {
                    try {
                        if (!(projectNamedItem instanceof ProjectNamedItem)) continue;
                        String projectPath = (String)((ProjectNamedItem)projectNamedItem).getLocation().content();
                        String projectLocation = new Path(projectPath).toPortableString();
                        ProjectImportUtil.importProject(PathBridge.create((Path)new Path(projectLocation)), (IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (Exception e) {
                        statusBuilder.add(StatusBridge.create((Status)Status.createErrorStatus((String)e.getMessage())));
                    }
                }
                return statusBuilder.retval();
            }
        };
        job.schedule();
        return retval;
    }
}

