/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.modules.PropertyKey;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.text.edits.TextEdit;

public class NewLiferayModuleProjectOpMethods {
    public static final Status execute(NewLiferayModuleProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay module project (this process may take several minutes)", 100);
        Status retval = null;
        try {
            IPath location;
            NewLiferayProjectProvider projectProvider = (NewLiferayProjectProvider)op.getProjectProvider().content(true);
            IStatus status = projectProvider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)status);
            String projectName = (String)op.getProjectName().content();
            String className = (String)op.getComponentName().content();
            String packageName = (String)op.getPackageName().content();
            String projectTemplateName = (String)op.getProjectTemplateName().content();
            IPath projectLocation = location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)op.getLocation().content()));
            String lastSegment = location.lastSegment();
            if (location != null && location.segmentCount() > 0 && !lastSegment.equals(projectName)) {
                projectLocation = location.append(projectName);
            }
            List<IPath> finalClassPaths = NewLiferayModuleProjectOpMethods.getClassFilePath(projectName, className, packageName, projectTemplateName, projectLocation);
            for (IPath classFilePath : finalClassPaths) {
                File finalClassFile = classFilePath.toFile();
                if (!finalClassFile.exists()) continue;
                ElementList<PropertyKey> propertyKeys = op.getPropertyKeys();
                ArrayList<String> properties = new ArrayList<String>();
                for (PropertyKey propertyKey : propertyKeys) {
                    properties.add(String.valueOf((String)propertyKey.getName().content(true)) + "=" + (String)propertyKey.getValue().content(true));
                }
                NewLiferayModuleProjectOpMethods.addProperties(finalClassFile, properties);
                CoreUtil.getProject((String)((String)op.getProjectName().content())).refreshLocal(2, monitor);
            }
            if (retval.ok()) {
                NewLiferayModuleProjectOpMethods.updateBuildPrefs(op);
            }
        }
        catch (Exception e) {
            String msg = "Error creating Liferay module project.";
            ProjectCore.logError("Error creating Liferay module project.", e);
            return Status.createErrorStatus((String)("Error creating Liferay module project. " + e.getMessage()), (Throwable)e);
        }
        return retval;
    }

    private static void updateBuildPrefs(NewLiferayModuleProjectOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-module-default-build-type-option", op.getProjectProvider().text());
            prefs.flush();
        }
        catch (Exception e) {
            String msg = "Error updating default project build type.";
            ProjectCore.logError("Error updating default project build type.", e);
        }
    }

    private static void getClassFile(File packageRoot, List<IPath> classFiles) {
        File[] children = packageRoot.listFiles();
        if (children != null && children.length > 0) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    NewLiferayModuleProjectOpMethods.getClassFile(child, classFiles);
                } else {
                    try {
                        boolean hasComponentAnnotation = NewLiferayModuleProjectOpMethods.checkComponentAnnotation(child.getAbsoluteFile());
                        if (hasComponentAnnotation) {
                            classFiles.add((IPath)new Path(child.getAbsolutePath()));
                        }
                    }
                    catch (Exception e) {
                        ProjectCore.logError(e);
                    }
                }
                ++n2;
            }
        }
    }

    private static List<IPath> getClassFilePath(String projectName, String className, String packageName, String projectTemplateName, IPath projecLocation) {
        IPath packageNamePath = projecLocation.append("src/main/java");
        File packageRoot = packageNamePath.toFile();
        ArrayList<IPath> classFiles = new ArrayList<IPath>();
        NewLiferayModuleProjectOpMethods.getClassFile(packageRoot, classFiles);
        return classFiles;
    }

    public static String getMavenParentPomGroupId(NewLiferayModuleProjectOp op, String projectName, IPath path) {
        List groupId;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !CoreUtil.isNullOrEmpty((List)(groupId = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentGroupId", String.class, new Object[]{parentProjectDir})))) {
            retval = (String)groupId.get(0);
        }
        return retval;
    }

    public static String getMavenParentPomVersion(NewLiferayModuleProjectOp op, String projectName, IPath path) {
        List version;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !CoreUtil.isNullOrEmpty((List)(version = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentVersion", String.class, new Object[]{parentProjectDir})))) {
            retval = (String)version.get(0);
        }
        return retval;
    }

    public static boolean checkComponentAnnotation(File dest) throws Exception {
        try {
            ASTParser parser = ASTParser.newParser((int)8);
            String readContents = FileUtil.readContents((File)dest, (boolean)true);
            parser.setSource(readContents.toCharArray());
            parser.setKind(8);
            parser.setResolveBindings(true);
            CompilationUnit cu = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            CheckComponentAnnotationVistor componentAnnotationVistor = new CheckComponentAnnotationVistor();
            cu.accept((ASTVisitor)componentAnnotationVistor);
            return componentAnnotationVistor.hasComponentAnnotation();
        }
        catch (Exception e) {
            ProjectCore.logError("error when adding properties to " + dest.getAbsolutePath(), e);
            return false;
        }
    }

    public static void addProperties(final File dest, final List<String> properties) throws Exception {
        try {
            if (properties == null || properties.size() < 1) {
                return;
            }
            ASTParser parser = ASTParser.newParser((int)8);
            String readContents = FileUtil.readContents((File)dest, (boolean)true);
            parser.setSource(readContents.toCharArray());
            parser.setKind(8);
            parser.setResolveBindings(true);
            final CompilationUnit cu = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            cu.recordModifications();
            final Document document = new Document(new String(readContents));
            cu.accept(new ASTVisitor(){

                public boolean visit(NormalAnnotation node) {
                    if (node.getTypeName().getFullyQualifiedName().equals("Component")) {
                        Object clrw;
                        ASTRewrite rewrite = ASTRewrite.create((AST)cu.getAST());
                        AST ast = cu.getAST();
                        List values = node.values();
                        boolean hasProperty = false;
                        for (ASTNode astNode : values) {
                            MemberValuePair pairNode;
                            if (!(astNode instanceof MemberValuePair) || !(pairNode = (MemberValuePair)astNode).getName().getFullyQualifiedName().equals("property")) continue;
                            Expression express = pairNode.getValue();
                            if (express instanceof ArrayInitializer) {
                                ListRewrite lrw = rewrite.getListRewrite((ASTNode)express, ArrayInitializer.EXPRESSIONS_PROPERTY);
                                ArrayInitializer initializer = (ArrayInitializer)express;
                                List expressions = initializer.expressions();
                                ASTNode propertyNode = null;
                                int i = properties.size() - 1;
                                while (i >= 0) {
                                    StringLiteral stringLiteral = ast.newStringLiteral();
                                    stringLiteral.setLiteralValue((String)properties.get(i));
                                    if (expressions.size() > 0) {
                                        propertyNode = (ASTNode)expressions.get(expressions.size() - 1);
                                        lrw.insertAfter((ASTNode)stringLiteral, propertyNode, null);
                                    } else {
                                        lrw.insertFirst((ASTNode)stringLiteral, null);
                                    }
                                    --i;
                                }
                            }
                            hasProperty = true;
                        }
                        if (!hasProperty) {
                            clrw = rewrite.getListRewrite((ASTNode)node, NormalAnnotation.VALUES_PROPERTY);
                            ASTNode lastNode = (ASTNode)values.get(values.size() - 1);
                            ArrayInitializer newArrayInitializer = ast.newArrayInitializer();
                            MemberValuePair propertyMemberValuePair = ast.newMemberValuePair();
                            propertyMemberValuePair.setName(ast.newSimpleName("property"));
                            propertyMemberValuePair.setValue((Expression)newArrayInitializer);
                            clrw.insertBefore((ASTNode)propertyMemberValuePair, lastNode, null);
                            ListRewrite newLrw = rewrite.getListRewrite((ASTNode)newArrayInitializer, ArrayInitializer.EXPRESSIONS_PROPERTY);
                            for (String property : properties) {
                                StringLiteral stringLiteral = ast.newStringLiteral();
                                stringLiteral.setLiteralValue(property);
                                newLrw.insertAt((ASTNode)stringLiteral, 0, null);
                            }
                        }
                        try {
                            clrw = null;
                            Iterator iterator = null;
                            try (FileOutputStream fos = new FileOutputStream(dest);){
                                TextEdit edits = rewrite.rewriteAST((IDocument)document, null);
                                edits.apply((IDocument)document);
                                fos.write(document.get().getBytes());
                                fos.flush();
                            }
                            catch (Throwable throwable) {
                                if (clrw == null) {
                                    clrw = throwable;
                                } else if (clrw != throwable) {
                                    ((Throwable)clrw).addSuppressed(throwable);
                                }
                                throw clrw;
                            }
                        }
                        catch (Exception e) {
                            ProjectCore.logError(e);
                        }
                    }
                    return super.visit(node);
                }
            });
        }
        catch (Exception e) {
            ProjectCore.logError("error when adding properties to " + dest.getAbsolutePath(), e);
        }
    }

    private static class CheckComponentAnnotationVistor
    extends ASTVisitor {
        private boolean hasComponentAnnotation = false;

        public boolean visit(NormalAnnotation node) {
            if (node.getTypeName().getFullyQualifiedName().equals("Component")) {
                this.hasComponentAnnotation = true;
            }
            return super.visit(node);
        }

        public boolean hasComponentAnnotation() {
            return this.hasComponentAnnotation;
        }
    }
}

